/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.search.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.util.db.Criteria;
import org.openprivacy.reptile.search.AbstractSearchProvider;
import org.openprivacy.reptile.search.SearchRequest;

public abstract class DBSearchProvider
extends AbstractSearchProvider {
    private Class peer = null;
    private Vector results = null;
    protected List defaultSearchFields = new ArrayList();
    protected List defaultSortOrder = new ArrayList();
    static /* synthetic */ Class class$org$apache$turbine$util$db$Criteria;

    public DBSearchProvider(Class peer) {
        this.peer = peer;
    }

    public void search(SearchRequest sr) throws Exception {
        this.assertSearchable();
        sr.assertValid();
        this.setSearchRequest(sr);
        this.setState(2);
        if (sr.getSearchFields().size() == 0) {
            Iterator dfi = this.defaultSearchFields.iterator();
            while (dfi.hasNext()) {
                sr.getSearchFields().add(dfi.next());
            }
        }
        if (sr.getSortOrder().size() == 0) {
            Iterator sfi = this.defaultSortOrder.iterator();
            while (sfi.hasNext()) {
                sr.getSortOrder().add(sfi.next());
            }
        }
        Iterator fields = sr.getSearchFields().iterator();
        Iterator order = sr.getSortOrder().iterator();
        String comparator = this.getSearchRequest().getComparator();
        Criteria criteria = new Criteria();
        Criteria.Criterion criterion = null;
        Criteria.Criterion last_crit = null;
        criteria.setIgnoreCase(true);
        String tablename = this.getTableName();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            if (!field.startsWith(tablename)) {
                field = tablename + "." + field.toUpperCase();
            }
            Iterator search_criteria = sr.getCriteria().iterator();
            while (search_criteria.hasNext()) {
                Object search_string = search_criteria.next();
                if (comparator.equals(" LIKE ") && search_string instanceof String) {
                    search_string = "%" + (String)search_string + "%";
                }
                Criteria.Criterion c = criteria.getNewCriterion(field, search_string, comparator);
                if (criterion == null) {
                    criterion = c;
                } else {
                    last_crit.or(c);
                }
                last_crit = c;
            }
        }
        criteria.add(criterion);
        while (order.hasNext()) {
            criteria.addDescendingOrderByColumn((String)order.next());
        }
        Class[] params = new Class[]{class$org$apache$turbine$util$db$Criteria == null ? (class$org$apache$turbine$util$db$Criteria = DBSearchProvider.class$("org.apache.turbine.util.db.Criteria")) : class$org$apache$turbine$util$db$Criteria};
        Method doSelect = this.peer.getMethod("doSelect", params);
        Object[] args = new Object[]{criteria};
        if (this.requiresMaxRows()) {
            criteria.setLimit(sr.getMaxCount());
        }
        this.results = (Vector)doSelect.invoke(null, args);
        this.setResultCount(this.results.size());
        this.setState(4);
    }

    private boolean requiresMaxRows() {
        SearchRequest sr = this.getSearchRequest();
        return sr.getMaxCount() != -1 && sr.getMaxCount() > 0;
    }

    protected Vector getResults() {
        return this.results;
    }

    private String getTableName() throws Exception {
        return (String)this.peer.getField("TABLE_NAME").get(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

