/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.search;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;
import org.openprivacy.reptile.om.ArticlePeer;
import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.search.SearchRecord;
import org.openprivacy.reptile.search.SearchRequest;
import org.openprivacy.reptile.util.ReptileNamespaces;
import org.w3c.dom.Node;
import talon.util.Log;

public class SearchSerializer {
    public static final int FIRST_PAGE = 0;
    public static final int RECORDS_PER_PAGE = 10;
    private SearchProvider provider = null;

    public SearchSerializer(SearchProvider provider) {
        this.setProvider(provider);
    }

    public int getPageCount() {
        return 1 + (int)Math.floor((this.provider.getResultCount() - 1) / 10);
    }

    public Element serialize(int page) throws Exception {
        if (page > this.getPageCount() || page < 0) {
            throw new Exception("Invalid page: " + page);
        }
        int start = page * 10;
        int end = start + 10 - 1;
        SearchRecord visitor = new SearchRecord();
        Element search = new Element("search", ReptileNamespaces.JDOM_SEARCH);
        search.setAttribute("provider-handle", this.provider.getHandle());
        int state = this.provider.getState();
        search.setAttribute("provider-state", this.provider.getState(state));
        search.setAttribute("provider-name", this.getClassWithoutPackage(this.provider));
        search.setAttribute("request-name", this.getClassWithoutPackage(this.provider.getSearchRequest()));
        long started = this.provider.getSearchStartTime();
        long completed = this.provider.getSearchCompletedTime();
        search.setAttribute("search-started", Long.toString(started));
        search.setAttribute("search-completed", Long.toString(completed));
        search.setAttribute("search-time", Long.toString(completed - started));
        SearchRequest request = this.provider.getSearchRequest();
        if (request != null) {
            search.addContent(request.serialize());
        } else {
            Log.warn((String)("Provider has not set its SearchRequest: " + this.provider.getClass().getName()));
        }
        Element results = new Element("results", ReptileNamespaces.JDOM_SEARCH);
        int returning = 0;
        int index = start;
        while (index <= end && index < this.provider.getResultCount()) {
            visitor.setIndex(index);
            this.provider.record(visitor);
            results.addContent(visitor.serialize());
            ++returning;
            ++index;
        }
        if (returning == 10) {
            --index;
        }
        results.setAttribute("start", Long.toString(start));
        results.setAttribute("end", Long.toString(index));
        results.setAttribute("found", Long.toString(this.provider.getResultCount()));
        results.setAttribute("total", Long.toString(ArticlePeer.getCount()));
        results.setAttribute("page", Long.toString(page));
        results.setAttribute("total-pages", Long.toString(this.getPageCount()));
        search.addContent(results);
        return search;
    }

    public String serializeAsString(int page) throws Exception {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setEncoding("ISO-8859-1");
        return outputter.outputString(this.serialize(page));
    }

    public Node serializeAsNode(int page) throws Exception {
        return new DOMOutputter().output(this.serialize(page));
    }

    public org.w3c.dom.Document serializeAsDocument(int page) throws Exception {
        return new DOMOutputter().output(new Document(this.serialize(page)));
    }

    public SearchProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SearchProvider provider) {
        this.provider = provider;
    }

    private String getClassWithoutPackage(Object object) {
        if (object == null) {
            return "not-available";
        }
        String name = object.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1, name.length());
        return name;
    }
}

