/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.jdom.Element;
import org.openprivacy.reptile.util.ReptileNamespaces;

public class SearchRequest {
    public static final int BOOLEAN_OR = 1;
    public static final int BOOLEAN_AND = 2;
    public static final String EQUAL = "=";
    public static final String NOT_EQUAL = "<>";
    public static final String ALT_NOT_EQUAL = "!=";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN = "<";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS_EQUAL = "<=";
    public static final String LIKE = " LIKE ";
    public static final String CUSTOM = "CUSTOM";
    public static final String DISTINCT = "DISTINCT ";
    public static final String IN = " IN ";
    public static final String NOT_IN = " NOT IN ";
    public static final String ALL = "ALL ";
    public static final String JOIN = "JOIN";
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    public static final int NO_MAXCOUNT = -1;
    private List criteria = new ArrayList();
    private List searchFields = new ArrayList();
    private List sortOrder = new ArrayList();
    private int maxCount = -1;
    private ExtendedProperties ep = new ExtendedProperties();
    private int booleanOperator = 1;
    private String comparator = " LIKE ";

    public List getCriteria() {
        return this.criteria;
    }

    public void addCriteria(String criteria) {
        this.criteria.add(criteria);
    }

    public void addCriteria(Long criteria) {
        this.criteria.add(criteria);
    }

    public void setCriteria(List criteria) {
        this.criteria = criteria;
    }

    public List getSearchFields() {
        return this.searchFields;
    }

    public void addSearchField(String field) {
        this.searchFields.add(field);
    }

    public void setSearchFields(List searchFields) {
        this.searchFields = searchFields;
    }

    public List getSortOrder() {
        return this.sortOrder;
    }

    public void addSortOrder(String field) {
        this.sortOrder.add(field);
    }

    public void setSortOrder(List sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public ExtendedProperties getExtendedProperties() {
        return this.ep;
    }

    public Element serialize() {
        Element request = new Element("request", ReptileNamespaces.JDOM_SEARCH);
        request.setAttribute("max-count", Integer.toString(this.getMaxCount()));
        request.addContent(this.serializeList("criteria", this.getCriteria()));
        request.addContent(this.serializeList("search-fields", this.getSearchFields()));
        request.addContent(this.serializeList("sort-order", this.getSortOrder()));
        return request;
    }

    private Element serializeList(String parent, List list) {
        Element result = new Element(parent, ReptileNamespaces.JDOM_SEARCH);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String next = it.next().toString();
            result.addContent(new Element("string", ReptileNamespaces.JDOM_XS).setText(next));
        }
        return result;
    }

    public void assertValid() throws Exception {
        if (this.getCriteria().size() == 0) {
            throw new Exception("Need to specify criteria.");
        }
    }

    public int getBooleanOperator() {
        return this.booleanOperator;
    }

    public void setBooleanOperator(int booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }
}

