/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.search;

import org.jdom.Element;
import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.util.ReptileNamespaces;

public class SearchRecord {
    private String channel = null;
    public static final int NO_INDEX = -1;
    private long dateFound;
    private String description = "";
    private String title = "";
    private String link = "";
    private int index = -1;

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDateFound(long dateFound) {
        this.dateFound = dateFound;
    }

    public long getDateFound() {
        return this.dateFound;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Element serialize() {
        Element entry = new Element("entry", ReptileNamespaces.JDOM_SEARCH);
        entry.addContent(new Element("title", ReptileNamespaces.JDOM_DC).setText(this.getTitle()));
        entry.addContent(new Element("description", ReptileNamespaces.JDOM_DC).setText(this.getDescription()));
        Element link = new Element("link", ReptileNamespaces.JDOM_SEARCH);
        link.setAttribute("date-found", Long.toString(this.getDateFound()));
        link.setAttribute("location", this.getLink());
        if (this.getChannel() != null) {
            link.setAttribute("channel", this.getChannel());
        }
        entry.addContent(link);
        return entry;
    }

    public void assertValid(SearchProvider provider) throws Exception {
        if (this.index == -1) {
            throw new Exception("Index for records not specified.  Must be > 0. " + this.index);
        }
        if (this.index > provider.getResultCount()) {
            throw new Exception("Index out of range - " + this.index);
        }
    }
}

