/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.search;

import java.util.HashMap;
import java.util.Iterator;
import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.search.SearchRequest;
import talon.util.Log;

public class SearchProviderManager {
    public static final String SEARCH_PROVIDER_PACKAGE = "org.openprivacy.reptile.search.impl.";
    public static final String ADVANCED_SEARCH_REQUEST_PACKAGE = "org.openprivacy.reptile.search.requests.";
    private static SearchProviderManager instance = null;
    private HashMap providers = new HashMap();

    public static SearchProviderManager getInstance() {
        if (instance == null) {
            instance = new SearchProviderManager();
        }
        return instance;
    }

    public SearchProvider newProvider(String classname, String request_name) throws Exception {
        SearchProvider provider = this.newProvider(Class.forName(classname));
        SearchRequest request = (SearchRequest)Class.forName(request_name).newInstance();
        provider.search(request);
        return provider;
    }

    public SearchProvider newProvider(String classname) throws Exception {
        return this.newProvider(Class.forName(classname));
    }

    public SearchProvider newProvider(String classname, boolean expand) throws Exception {
        if (expand) {
            classname = SEARCH_PROVIDER_PACKAGE + classname;
        }
        return this.newProvider(Class.forName(classname));
    }

    public SearchProvider newProvider(Class cprovider) throws Exception {
        SearchProvider sp = (SearchProvider)cprovider.newInstance();
        this.providers.put(sp.getHandle(), sp);
        return sp;
    }

    public void destroy(SearchProvider provider) {
        Log.debug((String)("Destroying SearchProvider: " + provider.getHandle()));
        try {
            provider.destroy();
            this.providers.remove(provider);
            provider = null;
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
        }
        this.providers.remove(provider.getHandle());
        provider = null;
    }

    public Iterator getSearchProviders() {
        return this.providers.values().iterator();
    }

    public int getSearchProviderCount() {
        return this.providers.values().size();
    }

    public SearchProvider getSearchProvider(String handle) throws Exception {
        SearchProvider sp = (SearchProvider)this.providers.get(handle);
        if (sp == null) {
            throw new Exception("Invalid search provider handle: " + handle);
        }
        return sp;
    }
}

