/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.search;

import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.search.SearchRequest;

public abstract class AbstractSearchProvider
implements SearchProvider {
    private long searchCompletedTime;
    private long searchStartTime;
    private SearchRequest searchRequest = null;
    private int state = 1;
    private int resultCount = 0;
    private long timeCreated = System.currentTimeMillis();
    private String handle = Long.toString(this.timeCreated);

    public final int getResultCount() {
        return this.resultCount;
    }

    public final void setResultCount(int resultCount) {
        this.resultCount = resultCount;
    }

    public final String getHandle() {
        return this.handle;
    }

    public final long getTimeCreated() {
        return this.timeCreated;
    }

    public final int getState() {
        return this.state;
    }

    public final String getState(int state) {
        switch (state) {
            case 1: {
                return "never-searched";
            }
            case 4: {
                return "search-complete";
            }
            case 2: {
                return "search-in-progress";
            }
        }
        return "unknown";
    }

    public final void setState(int state) {
        switch (state) {
            case 2: {
                this.setSearchStartTime(System.currentTimeMillis());
                break;
            }
            case 4: {
                this.setSearchCompletedTime(System.currentTimeMillis());
            }
        }
        this.state = state;
    }

    public final boolean isSearchable() {
        return this.getState() == 1;
    }

    public final void assertSearchable() throws Exception {
        if (!this.isSearchable()) {
            throw new Exception("This provider is not searchable.");
        }
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public void setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
    }

    public long getSearchStartTime() {
        return this.searchStartTime;
    }

    public void setSearchStartTime(long searchStartTime) {
        this.searchStartTime = searchStartTime;
    }

    public long getSearchCompletedTime() {
        return this.searchCompletedTime;
    }

    public void setSearchCompletedTime(long searchCompletedTime) {
        this.searchCompletedTime = searchCompletedTime;
    }
}

