/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.Record;
import java.util.Vector;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.openprivacy.reptile.ContentFeed;
import org.openprivacy.reptile.om.ArticlePeer;
import org.openprivacy.reptile.om.BaseChannelPeer;
import org.openprivacy.reptile.om.Category;
import org.openprivacy.reptile.om.CategoryPeer;
import org.openprivacy.reptile.om.Channel;

public class ChannelPeer
extends BaseChannelPeer {
    public static final int CHANNEL_UNINITIALIZED = 0;
    public static final int CHANNEL_INITIALIZED = 1;
    public static final int CHANNEL_UNSUBSCRIBED = 0;
    public static final int CHANNEL_SUBSCRIBED = 1;

    public static Channel getChannelByLocation(String location) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(LOCATION, (Object)location);
        Vector v = BaseChannelPeer.doSelect(criteria);
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return (Channel)((Object)v.elementAt(0));
        }
        throw new Exception("Too many channels found.  Location column needs to be unique.");
    }

    public static Channel[] getSubscriptionsByCategory(Category category) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(CATEGORY_FK, (Object)category.getId());
        criteria.add(SUBSCRIBED, 1);
        criteria.addAscendingOrderByColumn(TITLE);
        return ChannelPeer.returnChannels(criteria);
    }

    public static void registerChannel(ContentFeed feed) throws Exception {
        if (feed.getTitle() == null) {
            Log.debug((String)("Feed had a null title: " + feed.getLocation()));
            return;
        }
        Channel c = ChannelPeer.getChannelByLocation(feed.getLocation());
        if (c == null) {
            c = new Channel();
            c.setLocation(feed.getLocation());
        }
        if (c.getContentType() == null) {
            c.setContentType(feed.getContentType());
        }
        if (c.getTitle() == null) {
            c.setTitle(feed.getTitle());
        }
        if (c.getDescription() == null) {
            c.setDescription(feed.getDescription());
        }
        if (c.getSource() == null) {
            c.setSource(feed.getSource());
        }
        c.save();
    }

    public static synchronized void updateChannel(String location, String site, String contentType, String title, String description) throws Exception {
        boolean uninitialized;
        if (location == null || contentType == null) {
            throw new Exception("location or contentType not specified.");
        }
        Channel c = ChannelPeer.getChannelByLocation(location);
        if (c == null) {
            c = new Channel();
            c.setLocation(location);
        }
        boolean bl = uninitialized = c.getInitialized() == 0;
        if (contentType != null || uninitialized) {
            c.setContentType(contentType);
        }
        if (title != null || uninitialized) {
            c.setTitle(title);
        }
        if (description != null || uninitialized) {
            c.setDescription(description);
        }
        if (site != null || uninitialized) {
            c.setSite(site);
        }
        c.setInitialized(1);
        c.save();
    }

    public static int getCount() throws Exception {
        Vector v = BasePeer.executeQuery((String)("SELECT COUNT(*) FROM " + BaseChannelPeer.TABLE_NAME + ";"));
        Record record = (Record)v.elementAt(0);
        return record.getValue(1).asInt();
    }

    public static Channel[] searchByTitle(String query) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(TITLE, (Object)query, " LIKE ");
        criteria.addDescendingOrderByColumn(DATE_FOUND);
        return ChannelPeer.returnChannels(criteria);
    }

    public static Channel[] searchByDescription(String query) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(DESCRIPTION, (Object)query, " LIKE ");
        criteria.addDescendingOrderByColumn(DATE_FOUND);
        return ChannelPeer.returnChannels(criteria);
    }

    public static Channel[] searchByTitleAndDescription(String query) throws Exception {
        Criteria crit = new Criteria();
        Criteria.Criterion byTitle = crit.getNewCriterion(BaseChannelPeer.TITLE, (Object)query, " LIKE ");
        Criteria.Criterion byDescription = crit.getNewCriterion(BaseChannelPeer.DESCRIPTION, (Object)query, " LIKE ");
        crit.add(byTitle.or(byDescription));
        crit.addDescendingOrderByColumn(DATE_FOUND);
        return ChannelPeer.returnChannels(crit);
    }

    public static Channel[] getSubscriptions() throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(SUBSCRIBED, 1);
        criteria.addAscendingOrderByColumn(TITLE);
        return ChannelPeer.returnChannels(criteria);
    }

    public static void markChannelRead(String location) throws Exception {
        ChannelPeer.markChannel(location, 1);
    }

    public static void markChannelUnread(String location) throws Exception {
        ChannelPeer.markChannel(location, 0);
    }

    private static void markChannel(String location, int mark) throws Exception {
        Criteria selectCriteria = new Criteria();
        selectCriteria.add(ArticlePeer.CHANNEL, (Object)location);
        Criteria updateCriteria = new Criteria();
        updateCriteria.add(ArticlePeer.MARKED_READ, mark);
        ArticlePeer.doUpdate(selectCriteria, updateCriteria);
    }

    public static Channel getDefaultSubscription() {
        Criteria catc = new Criteria();
        catc.addAscendingOrderByColumn(CategoryPeer.NAME);
        catc.setLimit(1);
        return null;
    }

    private static Channel[] returnChannels(Criteria crit) throws Exception {
        Vector v = BaseChannelPeer.doSelect(crit);
        Channel[] channels = new Channel[v.size()];
        v.copyInto((Object[])channels);
        return channels;
    }
}

