/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.MapBuilder;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.pool.DBConnection;
import org.openprivacy.reptile.om.Weblog;
import org.openprivacy.reptile.om.WeblogPeer;
import org.openprivacy.reptile.om.map.WeblogMapBuilder;

public abstract class BaseWeblogPeer
extends BasePeer {
    private static final WeblogMapBuilder mapBuilder = (WeblogMapBuilder)BasePeer.getMapBuilder((String)"org.openprivacy.reptile.om.map.WeblogMapBuilder");
    public static final String TABLE_NAME = mapBuilder.getTable();
    public static final String ID = mapBuilder.getWeblog_Id();
    public static final String LOCATION = mapBuilder.getWeblog_Location();
    public static final String TITLE = mapBuilder.getWeblog_Title();
    public static final String DESCRIPTION = mapBuilder.getWeblog_Description();
    public static final String COMMENTS = mapBuilder.getWeblog_Comments();
    public static final String DC_SUBJECT = mapBuilder.getWeblog_DcSubject();
    public static final String DATE_FOUND = mapBuilder.getWeblog_DateFound();
    public static final String LAST_UPDATED = mapBuilder.getWeblog_LastUpdated();
    public static final int numColumns = 8;
    protected static final String CLASSNAME_DEFAULT = "org.openprivacy.reptile.om.Weblog";
    protected static final Class CLASS_DEFAULT = BaseWeblogPeer.initClass();

    public static MapBuilder getMapBuilder() {
        return mapBuilder;
    }

    private static Class initClass() {
        Class<?> c = null;
        try {
            c = Class.forName(CLASSNAME_DEFAULT);
        }
        catch (Exception e) {
            Log.error((String)"A FATAL ERROR has occurred which should nothave happened under any circumstance.  Please notifyTurbine and give as many details as possible including the error stacktrace.", (Throwable)e);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector resultSet2Objects(ResultSet results) throws Exception {
        QueryDataSet qds = null;
        Vector rows = null;
        try {
            qds = new QueryDataSet(results);
            rows = BasePeer.getSelectResults((QueryDataSet)qds);
            Object var4_3 = null;
            if (qds == null) return BaseWeblogPeer.populateObjects(rows);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (qds == null) throw throwable;
            qds.close();
            throw throwable;
        }
        qds.close();
        return BaseWeblogPeer.populateObjects(rows);
    }

    public static ObjectKey doInsert(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria);
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void addSelectColumns(Criteria criteria) throws Exception {
        criteria.addSelectColumn(ID);
        criteria.addSelectColumn(LOCATION);
        criteria.addSelectColumn(TITLE);
        criteria.addSelectColumn(DESCRIPTION);
        criteria.addSelectColumn(COMMENTS);
        criteria.addSelectColumn(DC_SUBJECT);
        criteria.addSelectColumn(DATE_FOUND);
        criteria.addSelectColumn(LAST_UPDATED);
    }

    public static Weblog row2Object(Record row, int offset, Class cls) throws Exception {
        Weblog obj = (Weblog)((Object)cls.newInstance());
        BaseWeblogPeer.populateObject(row, offset, obj);
        obj.setModified(false);
        obj.setNew(false);
        return obj;
    }

    public static void populateObject(Record row, int offset, Weblog obj) throws Exception {
        obj.setId(new NumberKey(row.getValue(offset + 0).asBigDecimal()));
        obj.setLocation(row.getValue(offset + 1).asString());
        obj.setTitle(row.getValue(offset + 2).asString());
        obj.setDescription(row.getValue(offset + 3).asString());
        obj.setComments(row.getValue(offset + 4).asString());
        obj.setDcSubject(row.getValue(offset + 5).asString());
        obj.setDateFound(row.getValue(offset + 6).asLong());
        obj.setLastUpdated(row.getValue(offset + 7).asLong());
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        return BaseWeblogPeer.populateObjects(BaseWeblogPeer.doSelectVillageRecords(criteria));
    }

    public static Vector doSelect(Criteria criteria, DBConnection dbCon) throws Exception {
        return BaseWeblogPeer.populateObjects(BaseWeblogPeer.doSelectVillageRecords(criteria, dbCon));
    }

    public static Vector doSelectVillageRecords(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        if (criteria.getSelectColumns().size() == 0) {
            BaseWeblogPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria);
    }

    public static Vector doSelectVillageRecords(Criteria criteria, DBConnection dbCon) throws Exception {
        if (criteria.getSelectColumns().size() == 0) {
            BaseWeblogPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (DBConnection)dbCon);
    }

    public static Vector populateObjects(Vector records) throws Exception {
        Vector<Weblog> results = new Vector<Weblog>(records.size());
        int i = 0;
        while (i < records.size()) {
            Record row = (Record)records.elementAt(i);
            results.add(WeblogPeer.row2Object(row, 1, WeblogPeer.getOMClass()));
            ++i;
        }
        return results;
    }

    public static Class getOMClass() throws Exception {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static void doUpdate(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doDelete(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria);
    }

    public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doInsert(Weblog obj) throws Exception {
        BaseWeblogPeer.doInsert(BaseWeblogPeer.buildCriteria(obj));
        obj.setNew(false);
    }

    public static void doUpdate(Weblog obj) throws Exception {
        BaseWeblogPeer.doUpdate(BaseWeblogPeer.buildCriteria(obj));
    }

    public static void doDelete(Weblog obj) throws Exception {
        BaseWeblogPeer.doDelete(BaseWeblogPeer.buildCriteria(obj));
    }

    public static void doInsert(Weblog obj, DBConnection dbCon) throws Exception {
        BaseWeblogPeer.doInsert(BaseWeblogPeer.buildCriteria(obj), dbCon);
        obj.setNew(false);
    }

    public static void doUpdate(Weblog obj, DBConnection dbCon) throws Exception {
        BaseWeblogPeer.doUpdate(BaseWeblogPeer.buildCriteria(obj), dbCon);
    }

    public static void doDelete(Weblog obj, DBConnection dbCon) throws Exception {
        BaseWeblogPeer.doDelete(BaseWeblogPeer.buildCriteria(obj), dbCon);
    }

    public static Criteria buildCriteria(Weblog obj) {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)obj.getId());
        criteria.add(LOCATION, (Object)obj.getLocation());
        criteria.add(TITLE, (Object)obj.getTitle());
        criteria.add(DESCRIPTION, (Object)obj.getDescription());
        criteria.add(COMMENTS, (Object)obj.getComments());
        criteria.add(DC_SUBJECT, (Object)obj.getDcSubject());
        criteria.add(DATE_FOUND, obj.getDateFound());
        criteria.add(LAST_UPDATED, obj.getLastUpdated());
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Weblog retrieveByPK(ObjectKey pk) throws Exception {
        DBConnection db = null;
        Weblog retVal = null;
        try {
            db = TurbineDB.getConnection((String)mapBuilder.getDatabaseMap().getName());
            retVal = BaseWeblogPeer.retrieveByPK(pk, db);
            Object var4_3 = null;
            if (db == null) return retVal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (db == null) throw throwable;
            TurbineDB.releaseConnection((DBConnection)db);
            throw throwable;
        }
        TurbineDB.releaseConnection((DBConnection)db);
        return retVal;
    }

    public static Weblog retrieveByPK(ObjectKey pk, DBConnection dbcon) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)pk);
        Vector v = BaseWeblogPeer.doSelect(criteria, dbcon);
        if (v.size() != 1) {
            throw new Exception("Failed to select one and only one row.");
        }
        return (Weblog)((Object)v.firstElement());
    }

    protected static TableMap getTableMap() {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }
}

