/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.SimpleKey;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.MapBuilder;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.pool.DBConnection;
import org.openprivacy.reptile.om.Channel;
import org.openprivacy.reptile.om.ChannelPeer;
import org.openprivacy.reptile.om.Monitor;
import org.openprivacy.reptile.om.MonitorPeer;
import org.openprivacy.reptile.om.map.MonitorMapBuilder;

public abstract class BaseMonitorPeer
extends BasePeer {
    private static final MonitorMapBuilder mapBuilder = (MonitorMapBuilder)BasePeer.getMapBuilder((String)"org.openprivacy.reptile.om.map.MonitorMapBuilder");
    public static final String TABLE_NAME = mapBuilder.getTable();
    public static final String ID = mapBuilder.getMonitor_Id();
    public static final String CHANNEL_FK = mapBuilder.getMonitor_ChannelFk();
    public static final int numColumns = 2;
    protected static final String CLASSNAME_DEFAULT = "org.openprivacy.reptile.om.Monitor";
    protected static final Class CLASS_DEFAULT = BaseMonitorPeer.initClass();

    public static MapBuilder getMapBuilder() {
        return mapBuilder;
    }

    private static Class initClass() {
        Class<?> c = null;
        try {
            c = Class.forName(CLASSNAME_DEFAULT);
        }
        catch (Exception e) {
            Log.error((String)"A FATAL ERROR has occurred which should nothave happened under any circumstance.  Please notifyTurbine and give as many details as possible including the error stacktrace.", (Throwable)e);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector resultSet2Objects(ResultSet results) throws Exception {
        QueryDataSet qds = null;
        Vector rows = null;
        try {
            qds = new QueryDataSet(results);
            rows = BasePeer.getSelectResults((QueryDataSet)qds);
            Object var4_3 = null;
            if (qds == null) return BaseMonitorPeer.populateObjects(rows);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (qds == null) throw throwable;
            qds.close();
            throw throwable;
        }
        qds.close();
        return BaseMonitorPeer.populateObjects(rows);
    }

    public static ObjectKey doInsert(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria);
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void addSelectColumns(Criteria criteria) throws Exception {
        criteria.addSelectColumn(ID);
        criteria.addSelectColumn(CHANNEL_FK);
    }

    public static Monitor row2Object(Record row, int offset, Class cls) throws Exception {
        Monitor obj = (Monitor)((Object)cls.newInstance());
        BaseMonitorPeer.populateObject(row, offset, obj);
        obj.setModified(false);
        obj.setNew(false);
        return obj;
    }

    public static void populateObject(Record row, int offset, Monitor obj) throws Exception {
        obj.setId(new NumberKey(row.getValue(offset + 0).asBigDecimal()));
        obj.setChannelFk(new NumberKey(row.getValue(offset + 1).asBigDecimal()));
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        return BaseMonitorPeer.populateObjects(BaseMonitorPeer.doSelectVillageRecords(criteria));
    }

    public static Vector doSelect(Criteria criteria, DBConnection dbCon) throws Exception {
        return BaseMonitorPeer.populateObjects(BaseMonitorPeer.doSelectVillageRecords(criteria, dbCon));
    }

    public static Vector doSelectVillageRecords(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        if (criteria.getSelectColumns().size() == 0) {
            BaseMonitorPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria);
    }

    public static Vector doSelectVillageRecords(Criteria criteria, DBConnection dbCon) throws Exception {
        if (criteria.getSelectColumns().size() == 0) {
            BaseMonitorPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (DBConnection)dbCon);
    }

    public static Vector populateObjects(Vector records) throws Exception {
        Vector<Monitor> results = new Vector<Monitor>(records.size());
        int i = 0;
        while (i < records.size()) {
            Record row = (Record)records.elementAt(i);
            results.add(MonitorPeer.row2Object(row, 1, MonitorPeer.getOMClass()));
            ++i;
        }
        return results;
    }

    public static Class getOMClass() throws Exception {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        selectCriteria.put((Object)CHANNEL_FK, criteria.remove(CHANNEL_FK));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static void doUpdate(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        selectCriteria.put((Object)CHANNEL_FK, criteria.remove(CHANNEL_FK));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doDelete(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria);
    }

    public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doInsert(Monitor obj) throws Exception {
        BaseMonitorPeer.doInsert(BaseMonitorPeer.buildCriteria(obj));
        obj.setNew(false);
    }

    public static void doUpdate(Monitor obj) throws Exception {
        BaseMonitorPeer.doUpdate(BaseMonitorPeer.buildCriteria(obj));
    }

    public static void doDelete(Monitor obj) throws Exception {
        BaseMonitorPeer.doDelete(BaseMonitorPeer.buildCriteria(obj));
    }

    public static void doInsert(Monitor obj, DBConnection dbCon) throws Exception {
        BaseMonitorPeer.doInsert(BaseMonitorPeer.buildCriteria(obj), dbCon);
        obj.setNew(false);
    }

    public static void doUpdate(Monitor obj, DBConnection dbCon) throws Exception {
        BaseMonitorPeer.doUpdate(BaseMonitorPeer.buildCriteria(obj), dbCon);
    }

    public static void doDelete(Monitor obj, DBConnection dbCon) throws Exception {
        BaseMonitorPeer.doDelete(BaseMonitorPeer.buildCriteria(obj), dbCon);
    }

    public static Criteria buildCriteria(Monitor obj) {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)obj.getId());
        criteria.add(CHANNEL_FK, (Object)obj.getChannelFk());
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Monitor retrieveByPK(ObjectKey pk) throws Exception {
        DBConnection db = null;
        Monitor retVal = null;
        try {
            db = TurbineDB.getConnection((String)mapBuilder.getDatabaseMap().getName());
            retVal = BaseMonitorPeer.retrieveByPK(pk, db);
            Object var4_3 = null;
            if (db == null) return retVal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (db == null) throw throwable;
            TurbineDB.releaseConnection((DBConnection)db);
            throw throwable;
        }
        TurbineDB.releaseConnection((DBConnection)db);
        return retVal;
    }

    public static Monitor retrieveByPK(ObjectKey pk, DBConnection dbcon) throws Exception {
        Criteria criteria = new Criteria();
        SimpleKey[] keys = (SimpleKey[])pk.getValue();
        criteria.add(ID, (Object)keys[0]);
        criteria.add(CHANNEL_FK, (Object)keys[1]);
        Vector v = BaseMonitorPeer.doSelect(criteria, dbcon);
        if (v.size() != 1) {
            throw new Exception("Failed to select one and only one row.");
        }
        return (Monitor)((Object)v.firstElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Monitor retrieveByPK(NumberKey id, NumberKey channel_fk) throws Exception {
        DBConnection db = null;
        Monitor retVal = null;
        try {
            db = TurbineDB.getConnection((String)mapBuilder.getDatabaseMap().getName());
            retVal = BaseMonitorPeer.retrieveByPK(id, channel_fk, db);
            Object var5_4 = null;
            if (db == null) return retVal;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (db == null) throw throwable;
            TurbineDB.releaseConnection((DBConnection)db);
            throw throwable;
        }
        TurbineDB.releaseConnection((DBConnection)db);
        return retVal;
    }

    public static Monitor retrieveByPK(NumberKey id, NumberKey channel_fk, DBConnection dbcon) throws Exception {
        Criteria criteria = new Criteria(5);
        criteria.add(ID, (Object)id);
        criteria.add(CHANNEL_FK, (Object)channel_fk);
        Vector v = BaseMonitorPeer.doSelect(criteria, dbcon);
        if (v.size() != 1) {
            throw new Exception("Failed to select one and only one row.");
        }
        return (Monitor)((Object)v.firstElement());
    }

    protected static Vector doSelectJoinChannel(Criteria c) throws Exception {
        c.setDbName(mapBuilder.getDatabaseMap().getName());
        MonitorPeer.addSelectColumns(c);
        int offset = 3;
        ChannelPeer.addSelectColumns(c);
        c.addJoin(MonitorPeer.CHANNEL_FK, ChannelPeer.ID);
        Vector rows = BasePeer.doSelect((Criteria)c);
        Vector<Monitor> results = new Vector<Monitor>();
        int i = 0;
        while (i < rows.size()) {
            Record row = (Record)rows.elementAt(i);
            Class omClass = MonitorPeer.getOMClass();
            Monitor obj1 = MonitorPeer.row2Object(row, 1, omClass);
            omClass = ChannelPeer.getOMClass();
            Channel obj2 = ChannelPeer.row2Object(row, offset, omClass);
            boolean newObject = true;
            int j = 0;
            while (j < results.size()) {
                Monitor temp_obj1 = (Monitor)((Object)results.elementAt(j));
                Channel temp_obj2 = temp_obj1.getChannel();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey())) {
                    newObject = false;
                    temp_obj2.addMonitor(obj1);
                    break;
                }
                ++j;
            }
            if (newObject) {
                obj2.initMonitors();
                obj2.addMonitor(obj1);
            }
            results.add(obj1);
            ++i;
        }
        return results;
    }

    protected static TableMap getTableMap() {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }
}

