/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.MapBuilder;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.pool.DBConnection;
import org.openprivacy.reptile.om.Image;
import org.openprivacy.reptile.om.ImagePeer;
import org.openprivacy.reptile.om.map.ImageMapBuilder;

public abstract class BaseImagePeer
extends BasePeer {
    private static final ImageMapBuilder mapBuilder = (ImageMapBuilder)BasePeer.getMapBuilder((String)"org.openprivacy.reptile.om.map.ImageMapBuilder");
    public static final String TABLE_NAME = mapBuilder.getTable();
    public static final String ID = mapBuilder.getImage_Id();
    public static final String CHANNEL = mapBuilder.getImage_Channel();
    public static final String LOCATION = mapBuilder.getImage_Location();
    public static final String WIDTH = mapBuilder.getImage_Width();
    public static final String HEIGHT = mapBuilder.getImage_Height();
    public static final String TITLE = mapBuilder.getImage_Title();
    public static final String DESCRIPTION = mapBuilder.getImage_Description();
    public static final int numColumns = 7;
    protected static final String CLASSNAME_DEFAULT = "org.openprivacy.reptile.om.Image";
    protected static final Class CLASS_DEFAULT = BaseImagePeer.initClass();

    public static MapBuilder getMapBuilder() {
        return mapBuilder;
    }

    private static Class initClass() {
        Class<?> c = null;
        try {
            c = Class.forName(CLASSNAME_DEFAULT);
        }
        catch (Exception e) {
            Log.error((String)"A FATAL ERROR has occurred which should nothave happened under any circumstance.  Please notifyTurbine and give as many details as possible including the error stacktrace.", (Throwable)e);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector resultSet2Objects(ResultSet results) throws Exception {
        QueryDataSet qds = null;
        Vector rows = null;
        try {
            qds = new QueryDataSet(results);
            rows = BasePeer.getSelectResults((QueryDataSet)qds);
            Object var4_3 = null;
            if (qds == null) return BaseImagePeer.populateObjects(rows);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (qds == null) throw throwable;
            qds.close();
            throw throwable;
        }
        qds.close();
        return BaseImagePeer.populateObjects(rows);
    }

    public static ObjectKey doInsert(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria);
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void addSelectColumns(Criteria criteria) throws Exception {
        criteria.addSelectColumn(ID);
        criteria.addSelectColumn(CHANNEL);
        criteria.addSelectColumn(LOCATION);
        criteria.addSelectColumn(WIDTH);
        criteria.addSelectColumn(HEIGHT);
        criteria.addSelectColumn(TITLE);
        criteria.addSelectColumn(DESCRIPTION);
    }

    public static Image row2Object(Record row, int offset, Class cls) throws Exception {
        Image obj = (Image)((Object)cls.newInstance());
        BaseImagePeer.populateObject(row, offset, obj);
        obj.setModified(false);
        obj.setNew(false);
        return obj;
    }

    public static void populateObject(Record row, int offset, Image obj) throws Exception {
        obj.setId(new NumberKey(row.getValue(offset + 0).asBigDecimal()));
        obj.setChannel(row.getValue(offset + 1).asString());
        obj.setLocation(row.getValue(offset + 2).asString());
        obj.setWidth(row.getValue(offset + 3).asInt());
        obj.setHeight(row.getValue(offset + 4).asInt());
        obj.setTitle(row.getValue(offset + 5).asString());
        obj.setDescription(row.getValue(offset + 6).asString());
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        return BaseImagePeer.populateObjects(BaseImagePeer.doSelectVillageRecords(criteria));
    }

    public static Vector doSelect(Criteria criteria, DBConnection dbCon) throws Exception {
        return BaseImagePeer.populateObjects(BaseImagePeer.doSelectVillageRecords(criteria, dbCon));
    }

    public static Vector doSelectVillageRecords(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        if (criteria.getSelectColumns().size() == 0) {
            BaseImagePeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria);
    }

    public static Vector doSelectVillageRecords(Criteria criteria, DBConnection dbCon) throws Exception {
        if (criteria.getSelectColumns().size() == 0) {
            BaseImagePeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (DBConnection)dbCon);
    }

    public static Vector populateObjects(Vector records) throws Exception {
        Vector<Image> results = new Vector<Image>(records.size());
        int i = 0;
        while (i < records.size()) {
            Record row = (Record)records.elementAt(i);
            results.add(ImagePeer.row2Object(row, 1, ImagePeer.getOMClass()));
            ++i;
        }
        return results;
    }

    public static Class getOMClass() throws Exception {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static void doUpdate(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doDelete(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria);
    }

    public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doInsert(Image obj) throws Exception {
        BaseImagePeer.doInsert(BaseImagePeer.buildCriteria(obj));
        obj.setNew(false);
    }

    public static void doUpdate(Image obj) throws Exception {
        BaseImagePeer.doUpdate(BaseImagePeer.buildCriteria(obj));
    }

    public static void doDelete(Image obj) throws Exception {
        BaseImagePeer.doDelete(BaseImagePeer.buildCriteria(obj));
    }

    public static void doInsert(Image obj, DBConnection dbCon) throws Exception {
        BaseImagePeer.doInsert(BaseImagePeer.buildCriteria(obj), dbCon);
        obj.setNew(false);
    }

    public static void doUpdate(Image obj, DBConnection dbCon) throws Exception {
        BaseImagePeer.doUpdate(BaseImagePeer.buildCriteria(obj), dbCon);
    }

    public static void doDelete(Image obj, DBConnection dbCon) throws Exception {
        BaseImagePeer.doDelete(BaseImagePeer.buildCriteria(obj), dbCon);
    }

    public static Criteria buildCriteria(Image obj) {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)obj.getId());
        criteria.add(CHANNEL, (Object)obj.getChannel());
        criteria.add(LOCATION, (Object)obj.getLocation());
        criteria.add(WIDTH, obj.getWidth());
        criteria.add(HEIGHT, obj.getHeight());
        criteria.add(TITLE, (Object)obj.getTitle());
        criteria.add(DESCRIPTION, (Object)obj.getDescription());
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Image retrieveByPK(ObjectKey pk) throws Exception {
        DBConnection db = null;
        Image retVal = null;
        try {
            db = TurbineDB.getConnection((String)mapBuilder.getDatabaseMap().getName());
            retVal = BaseImagePeer.retrieveByPK(pk, db);
            Object var4_3 = null;
            if (db == null) return retVal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (db == null) throw throwable;
            TurbineDB.releaseConnection((DBConnection)db);
            throw throwable;
        }
        TurbineDB.releaseConnection((DBConnection)db);
        return retVal;
    }

    public static Image retrieveByPK(ObjectKey pk, DBConnection dbcon) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)pk);
        Vector v = BaseImagePeer.doSelect(criteria, dbcon);
        if (v.size() != 1) {
            throw new Exception("Failed to select one and only one row.");
        }
        return (Image)((Object)v.firstElement());
    }

    protected static TableMap getTableMap() {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }
}

