/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import java.util.List;
import java.util.Vector;
import org.apache.turbine.om.BaseObject;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.Persistent;
import org.apache.turbine.om.Retrievable;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.pool.DBConnection;
import org.openprivacy.reptile.om.Channel;
import org.openprivacy.reptile.om.ChannelPeer;
import org.openprivacy.reptile.om.Image;
import org.openprivacy.reptile.om.ImagePeer;

public abstract class BaseImage
extends BaseObject
implements Retrievable {
    private NumberKey id;
    private String channel;
    private String location;
    private int width;
    private int height;
    private String title;
    private String description;
    protected Vector collChannels;
    private Criteria lastChannelsCriteria = null;
    private static Vector fieldNames_ = null;
    private boolean alreadyInSave = false;

    public NumberKey getId() {
        return this.id;
    }

    public void setId(NumberKey v) throws Exception {
        if (this.collChannels != null) {
            int i = 0;
            while (i < this.collChannels.size()) {
                ((Channel)((Object)this.collChannels.get(i))).setImageFk(v);
                ++i;
            }
        }
        if (!ObjectUtils.equals((Object)this.id, (Object)v)) {
            if (this.id == null) {
                this.id = new NumberKey(v);
            } else {
                this.id.setValue(v);
            }
            this.setModified(true);
        }
    }

    public void setId(String v) throws Exception {
        this.setId(new NumberKey(v));
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String v) {
        if (!ObjectUtils.equals((Object)this.channel, (Object)v)) {
            this.channel = v;
            this.setModified(true);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String v) {
        if (!ObjectUtils.equals((Object)this.location, (Object)v)) {
            this.location = v;
            this.setModified(true);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int v) {
        if (this.width != v) {
            this.width = v;
            this.setModified(true);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int v) {
        if (this.height != v) {
            this.height = v;
            this.setModified(true);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        if (!ObjectUtils.equals((Object)this.title, (Object)v)) {
            this.title = v;
            this.setModified(true);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        if (!ObjectUtils.equals((Object)this.description, (Object)v)) {
            this.description = v;
            this.setModified(true);
        }
    }

    protected void initChannels() {
        if (this.collChannels == null) {
            this.collChannels = new Vector();
        }
    }

    public void addChannel(Channel l) throws Exception {
        this.getChannels().add(l);
        l.setImage((Image)this);
    }

    public Vector getChannels() throws Exception {
        if (this.collChannels == null) {
            this.collChannels = this.getChannels(new Criteria(10));
        }
        return this.collChannels;
    }

    public Vector getChannels(Criteria criteria) throws Exception {
        if (this.collChannels == null) {
            if (this.isNew()) {
                this.collChannels = new Vector();
            } else {
                criteria.add(ChannelPeer.IMAGE_FK, (Object)this.getId());
                this.collChannels = ChannelPeer.doSelect(criteria);
            }
        } else if (!this.isNew()) {
            criteria.add(ChannelPeer.IMAGE_FK, (Object)this.getId());
            if (!this.lastChannelsCriteria.equals((Object)criteria)) {
                this.collChannels = ChannelPeer.doSelect(criteria);
            }
        }
        this.lastChannelsCriteria = criteria;
        return this.collChannels;
    }

    protected Vector getChannelsJoinCategory(Criteria criteria) throws Exception {
        if (this.collChannels == null) {
            if (this.isNew()) {
                this.collChannels = new Vector();
            } else {
                criteria.add(ChannelPeer.IMAGE_FK, (Object)this.getId());
                this.collChannels = ChannelPeer.doSelectJoinCategory(criteria);
            }
        } else {
            boolean newCriteria = true;
            criteria.add(ChannelPeer.IMAGE_FK, (Object)this.getId());
            if (!this.lastChannelsCriteria.equals((Object)criteria)) {
                this.collChannels = ChannelPeer.doSelectJoinCategory(criteria);
            }
        }
        this.lastChannelsCriteria = criteria;
        return this.collChannels;
    }

    public static synchronized List getFieldNames() {
        if (fieldNames_ == null) {
            fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("Channel");
            fieldNames_.add("Location");
            fieldNames_.add("Width");
            fieldNames_.add("Height");
            fieldNames_.add("Title");
            fieldNames_.add("Description");
        }
        return fieldNames_;
    }

    public Object getByName(String name) {
        if (name.equals("Id")) {
            return this.getId();
        }
        if (name.equals("Channel")) {
            return this.getChannel();
        }
        if (name.equals("Location")) {
            return this.getLocation();
        }
        if (name.equals("Width")) {
            return new Integer(this.getWidth());
        }
        if (name.equals("Height")) {
            return new Integer(this.getHeight());
        }
        if (name.equals("Title")) {
            return this.getTitle();
        }
        if (name.equals("Description")) {
            return this.getDescription();
        }
        return null;
    }

    public Object getByPeerName(String name) {
        if (name.equals(ImagePeer.ID)) {
            return this.getId();
        }
        if (name.equals(ImagePeer.CHANNEL)) {
            return this.getChannel();
        }
        if (name.equals(ImagePeer.LOCATION)) {
            return this.getLocation();
        }
        if (name.equals(ImagePeer.WIDTH)) {
            return new Integer(this.getWidth());
        }
        if (name.equals(ImagePeer.HEIGHT)) {
            return new Integer(this.getHeight());
        }
        if (name.equals(ImagePeer.TITLE)) {
            return this.getTitle();
        }
        if (name.equals(ImagePeer.DESCRIPTION)) {
            return this.getDescription();
        }
        return null;
    }

    public Object getByPosition(int pos) {
        if (pos == 0) {
            return this.getId();
        }
        if (pos == 1) {
            return this.getChannel();
        }
        if (pos == 2) {
            return this.getLocation();
        }
        if (pos == 3) {
            return new Integer(this.getWidth());
        }
        if (pos == 4) {
            return new Integer(this.getHeight());
        }
        if (pos == 5) {
            return this.getTitle();
        }
        if (pos == 6) {
            return this.getDescription();
        }
        return null;
    }

    public void save() throws Exception {
        this.save(ImagePeer.getMapBuilder().getDatabaseMap().getName());
    }

    public void save(String dbName) throws Exception {
        DBConnection dbCon = null;
        try {
            dbCon = BasePeer.beginTransaction((String)dbName);
            this.save(dbCon);
        }
        catch (Exception e) {
            BasePeer.rollBackTransaction((DBConnection)dbCon);
            throw e;
        }
        BasePeer.commitTransaction((DBConnection)dbCon);
    }

    public void save(DBConnection dbCon) throws Exception {
        if (!this.alreadyInSave) {
            this.alreadyInSave = true;
            if (this.isModified()) {
                if (this.isNew()) {
                    ImagePeer.doInsert((Image)this, dbCon);
                } else {
                    ImagePeer.doUpdate((Image)this, dbCon);
                    this.setNew(false);
                }
            }
            if (this.collChannels != null) {
                int i = 0;
                while (i < this.collChannels.size()) {
                    ((Channel)((Object)this.collChannels.get(i))).save(dbCon);
                    ++i;
                }
            }
            this.alreadyInSave = false;
        }
    }

    public void setPrimaryKey(ObjectKey id) throws Exception {
        this.setId((NumberKey)id);
    }

    public void setPrimaryKey(String key) throws Exception {
        this.setId(new NumberKey(key));
    }

    public ObjectKey getPrimaryKey() {
        return this.getId();
    }

    public String getQueryKey() {
        if (this.getPrimaryKey() == null) {
            return "";
        }
        return this.getPrimaryKey().toString();
    }

    public void setQueryKey(String key) throws Exception {
        this.setPrimaryKey(key);
    }

    public Image copy() throws Exception {
        Image copyObj = new Image();
        copyObj.setId(this.id);
        copyObj.setChannel(this.channel);
        copyObj.setLocation(this.location);
        copyObj.setWidth(this.width);
        copyObj.setHeight(this.height);
        copyObj.setTitle(this.title);
        copyObj.setDescription(this.description);
        Vector v = copyObj.getChannels();
        int i = 0;
        while (i < v.size()) {
            ((Persistent)v.get(i)).setNew(true);
            ++i;
        }
        copyObj.setId((NumberKey)null);
        return copyObj;
    }
}

