/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.MapBuilder;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.pool.DBConnection;
import org.openprivacy.reptile.om.Category;
import org.openprivacy.reptile.om.CategoryPeer;
import org.openprivacy.reptile.om.Channel;
import org.openprivacy.reptile.om.ChannelPeer;
import org.openprivacy.reptile.om.Image;
import org.openprivacy.reptile.om.ImagePeer;
import org.openprivacy.reptile.om.map.ChannelMapBuilder;

public abstract class BaseChannelPeer
extends BasePeer {
    private static final ChannelMapBuilder mapBuilder = (ChannelMapBuilder)BasePeer.getMapBuilder((String)"org.openprivacy.reptile.om.map.ChannelMapBuilder");
    public static final String TABLE_NAME = mapBuilder.getTable();
    public static final String ID = mapBuilder.getChannel_Id();
    public static final String LOCATION = mapBuilder.getChannel_Location();
    public static final String SITE = mapBuilder.getChannel_Site();
    public static final String CONTENT_TYPE = mapBuilder.getChannel_ContentType();
    public static final String TITLE = mapBuilder.getChannel_Title();
    public static final String DESCRIPTION = mapBuilder.getChannel_Description();
    public static final String IMAGE_FK = mapBuilder.getChannel_ImageFk();
    public static final String SOURCE = mapBuilder.getChannel_Source();
    public static final String DATE_FOUND = mapBuilder.getChannel_DateFound();
    public static final String LAST_UPDATED = mapBuilder.getChannel_LastUpdated();
    public static final String COPYRIGHT = mapBuilder.getChannel_Copyright();
    public static final String CATEGORY_FK = mapBuilder.getChannel_CategoryFk();
    public static final String SUBSCRIBED = mapBuilder.getChannel_Subscribed();
    public static final String INDEXED = mapBuilder.getChannel_Indexed();
    public static final String INITIALIZED = mapBuilder.getChannel_Initialized();
    public static final String PUBLISHER = mapBuilder.getChannel_Publisher();
    public static final String CREATOR = mapBuilder.getChannel_Creator();
    public static final int numColumns = 17;
    protected static final String CLASSNAME_DEFAULT = "org.openprivacy.reptile.om.Channel";
    protected static final Class CLASS_DEFAULT = BaseChannelPeer.initClass();

    public static MapBuilder getMapBuilder() {
        return mapBuilder;
    }

    private static Class initClass() {
        Class<?> c = null;
        try {
            c = Class.forName(CLASSNAME_DEFAULT);
        }
        catch (Exception e) {
            Log.error((String)"A FATAL ERROR has occurred which should nothave happened under any circumstance.  Please notifyTurbine and give as many details as possible including the error stacktrace.", (Throwable)e);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector resultSet2Objects(ResultSet results) throws Exception {
        QueryDataSet qds = null;
        Vector rows = null;
        try {
            qds = new QueryDataSet(results);
            rows = BasePeer.getSelectResults((QueryDataSet)qds);
            Object var4_3 = null;
            if (qds == null) return BaseChannelPeer.populateObjects(rows);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (qds == null) throw throwable;
            qds.close();
            throw throwable;
        }
        qds.close();
        return BaseChannelPeer.populateObjects(rows);
    }

    public static ObjectKey doInsert(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria);
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void addSelectColumns(Criteria criteria) throws Exception {
        criteria.addSelectColumn(ID);
        criteria.addSelectColumn(LOCATION);
        criteria.addSelectColumn(SITE);
        criteria.addSelectColumn(CONTENT_TYPE);
        criteria.addSelectColumn(TITLE);
        criteria.addSelectColumn(DESCRIPTION);
        criteria.addSelectColumn(IMAGE_FK);
        criteria.addSelectColumn(SOURCE);
        criteria.addSelectColumn(DATE_FOUND);
        criteria.addSelectColumn(LAST_UPDATED);
        criteria.addSelectColumn(COPYRIGHT);
        criteria.addSelectColumn(CATEGORY_FK);
        criteria.addSelectColumn(SUBSCRIBED);
        criteria.addSelectColumn(INDEXED);
        criteria.addSelectColumn(INITIALIZED);
        criteria.addSelectColumn(PUBLISHER);
        criteria.addSelectColumn(CREATOR);
    }

    public static Channel row2Object(Record row, int offset, Class cls) throws Exception {
        Channel obj = (Channel)((Object)cls.newInstance());
        BaseChannelPeer.populateObject(row, offset, obj);
        obj.setModified(false);
        obj.setNew(false);
        return obj;
    }

    public static void populateObject(Record row, int offset, Channel obj) throws Exception {
        obj.setId(new NumberKey(row.getValue(offset + 0).asBigDecimal()));
        obj.setLocation(row.getValue(offset + 1).asString());
        obj.setSite(row.getValue(offset + 2).asString());
        obj.setContentType(row.getValue(offset + 3).asString());
        obj.setTitle(row.getValue(offset + 4).asString());
        obj.setDescription(row.getValue(offset + 5).asString());
        obj.setImageFk(new NumberKey(row.getValue(offset + 6).asBigDecimal()));
        obj.setSource(row.getValue(offset + 7).asString());
        obj.setDateFound(row.getValue(offset + 8).asLong());
        obj.setLastUpdated(row.getValue(offset + 9).asLong());
        obj.setCopyright(row.getValue(offset + 10).asString());
        obj.setCategoryFk(new NumberKey(row.getValue(offset + 11).asBigDecimal()));
        obj.setSubscribed(row.getValue(offset + 12).asInt());
        obj.setIndexed(row.getValue(offset + 13).asInt());
        obj.setInitialized(row.getValue(offset + 14).asInt());
        obj.setPublisher(row.getValue(offset + 15).asString());
        obj.setCreator(row.getValue(offset + 16).asString());
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        return BaseChannelPeer.populateObjects(BaseChannelPeer.doSelectVillageRecords(criteria));
    }

    public static Vector doSelect(Criteria criteria, DBConnection dbCon) throws Exception {
        return BaseChannelPeer.populateObjects(BaseChannelPeer.doSelectVillageRecords(criteria, dbCon));
    }

    public static Vector doSelectVillageRecords(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        if (criteria.getSelectColumns().size() == 0) {
            BaseChannelPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria);
    }

    public static Vector doSelectVillageRecords(Criteria criteria, DBConnection dbCon) throws Exception {
        if (criteria.getSelectColumns().size() == 0) {
            BaseChannelPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (DBConnection)dbCon);
    }

    public static Vector populateObjects(Vector records) throws Exception {
        Vector<Channel> results = new Vector<Channel>(records.size());
        int i = 0;
        while (i < records.size()) {
            Record row = (Record)records.elementAt(i);
            results.add(ChannelPeer.row2Object(row, 1, ChannelPeer.getOMClass()));
            ++i;
        }
        return results;
    }

    public static Class getOMClass() throws Exception {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static void doUpdate(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doDelete(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria);
    }

    public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doInsert(Channel obj) throws Exception {
        BaseChannelPeer.doInsert(BaseChannelPeer.buildCriteria(obj));
        obj.setNew(false);
    }

    public static void doUpdate(Channel obj) throws Exception {
        BaseChannelPeer.doUpdate(BaseChannelPeer.buildCriteria(obj));
    }

    public static void doDelete(Channel obj) throws Exception {
        BaseChannelPeer.doDelete(BaseChannelPeer.buildCriteria(obj));
    }

    public static void doInsert(Channel obj, DBConnection dbCon) throws Exception {
        BaseChannelPeer.doInsert(BaseChannelPeer.buildCriteria(obj), dbCon);
        obj.setNew(false);
    }

    public static void doUpdate(Channel obj, DBConnection dbCon) throws Exception {
        BaseChannelPeer.doUpdate(BaseChannelPeer.buildCriteria(obj), dbCon);
    }

    public static void doDelete(Channel obj, DBConnection dbCon) throws Exception {
        BaseChannelPeer.doDelete(BaseChannelPeer.buildCriteria(obj), dbCon);
    }

    public static Criteria buildCriteria(Channel obj) {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)obj.getId());
        criteria.add(LOCATION, (Object)obj.getLocation());
        criteria.add(SITE, (Object)obj.getSite());
        criteria.add(CONTENT_TYPE, (Object)obj.getContentType());
        criteria.add(TITLE, (Object)obj.getTitle());
        criteria.add(DESCRIPTION, (Object)obj.getDescription());
        criteria.add(IMAGE_FK, (Object)obj.getImageFk());
        criteria.add(SOURCE, (Object)obj.getSource());
        criteria.add(DATE_FOUND, obj.getDateFound());
        criteria.add(LAST_UPDATED, obj.getLastUpdated());
        criteria.add(COPYRIGHT, (Object)obj.getCopyright());
        criteria.add(CATEGORY_FK, (Object)obj.getCategoryFk());
        criteria.add(SUBSCRIBED, obj.getSubscribed());
        criteria.add(INDEXED, obj.getIndexed());
        criteria.add(INITIALIZED, obj.getInitialized());
        criteria.add(PUBLISHER, (Object)obj.getPublisher());
        criteria.add(CREATOR, (Object)obj.getCreator());
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Channel retrieveByPK(ObjectKey pk) throws Exception {
        DBConnection db = null;
        Channel retVal = null;
        try {
            db = TurbineDB.getConnection((String)mapBuilder.getDatabaseMap().getName());
            retVal = BaseChannelPeer.retrieveByPK(pk, db);
            Object var4_3 = null;
            if (db == null) return retVal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (db == null) throw throwable;
            TurbineDB.releaseConnection((DBConnection)db);
            throw throwable;
        }
        TurbineDB.releaseConnection((DBConnection)db);
        return retVal;
    }

    public static Channel retrieveByPK(ObjectKey pk, DBConnection dbcon) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)pk);
        Vector v = BaseChannelPeer.doSelect(criteria, dbcon);
        if (v.size() != 1) {
            throw new Exception("Failed to select one and only one row.");
        }
        return (Channel)((Object)v.firstElement());
    }

    protected static Vector doSelectJoinImage(Criteria c) throws Exception {
        c.setDbName(mapBuilder.getDatabaseMap().getName());
        ChannelPeer.addSelectColumns(c);
        int offset = 18;
        ImagePeer.addSelectColumns(c);
        c.addJoin(ChannelPeer.IMAGE_FK, ImagePeer.ID);
        Vector rows = BasePeer.doSelect((Criteria)c);
        Vector<Channel> results = new Vector<Channel>();
        int i = 0;
        while (i < rows.size()) {
            Record row = (Record)rows.elementAt(i);
            Class omClass = ChannelPeer.getOMClass();
            Channel obj1 = ChannelPeer.row2Object(row, 1, omClass);
            omClass = ImagePeer.getOMClass();
            Image obj2 = ImagePeer.row2Object(row, offset, omClass);
            boolean newObject = true;
            int j = 0;
            while (j < results.size()) {
                Channel temp_obj1 = (Channel)((Object)results.elementAt(j));
                Image temp_obj2 = temp_obj1.getImage();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey())) {
                    newObject = false;
                    temp_obj2.addChannel(obj1);
                    break;
                }
                ++j;
            }
            if (newObject) {
                obj2.initChannels();
                obj2.addChannel(obj1);
            }
            results.add(obj1);
            ++i;
        }
        return results;
    }

    protected static Vector doSelectJoinCategory(Criteria c) throws Exception {
        c.setDbName(mapBuilder.getDatabaseMap().getName());
        ChannelPeer.addSelectColumns(c);
        int offset = 18;
        CategoryPeer.addSelectColumns(c);
        c.addJoin(ChannelPeer.CATEGORY_FK, CategoryPeer.ID);
        Vector rows = BasePeer.doSelect((Criteria)c);
        Vector<Channel> results = new Vector<Channel>();
        int i = 0;
        while (i < rows.size()) {
            Record row = (Record)rows.elementAt(i);
            Class omClass = ChannelPeer.getOMClass();
            Channel obj1 = ChannelPeer.row2Object(row, 1, omClass);
            omClass = CategoryPeer.getOMClass();
            Category obj2 = CategoryPeer.row2Object(row, offset, omClass);
            boolean newObject = true;
            int j = 0;
            while (j < results.size()) {
                Channel temp_obj1 = (Channel)((Object)results.elementAt(j));
                Category temp_obj2 = temp_obj1.getCategory();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey())) {
                    newObject = false;
                    temp_obj2.addChannel(obj1);
                    break;
                }
                ++j;
            }
            if (newObject) {
                obj2.initChannels();
                obj2.addChannel(obj1);
            }
            results.add(obj1);
            ++i;
        }
        return results;
    }

    protected static TableMap getTableMap() {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }
}

