/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.Record;
import java.util.Vector;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.openprivacy.reptile.om.Article;
import org.openprivacy.reptile.om.BaseArticlePeer;
import org.openprivacy.reptile.om.Channel;
import org.openprivacy.reptile.om.ChannelPeer;
import talon.util.RuntimeUtil;

public class ArticlePeer
extends BaseArticlePeer {
    public static final int S_MARKED_UNREAD = 0;
    public static final int S_MARKED_READ = 1;
    public static final int S_ARTICLE_MAXROWS = 15;
    public static final int S_MAXROWS_DEFAULT = 0;

    public static Article getArticleByLocation(String location) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(LOCATION, (Object)location);
        criteria.addDescendingOrderByColumn(DATE_FOUND);
        Vector v = BaseArticlePeer.doSelect(criteria);
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return (Article)((Object)v.elementAt(0));
        }
        throw new Exception("Too many channels found.  Location column needs to be unique.");
    }

    public static synchronized void updateArticle(String location, String channelLocation, String title, String description) throws Exception {
        Channel channel = ChannelPeer.getChannelByLocation(channelLocation);
        Article content = ArticlePeer.getArticleByLocation(location);
        if (content == null) {
            content = new Article();
        }
        content.setLocation(location);
        content.setTitle(title);
        content.setDescription(description);
        content.setChannel(channelLocation);
        content.save();
    }

    public static int getCount() throws Exception {
        Vector v = BasePeer.executeQuery((String)("SELECT COUNT(*) FROM " + BaseArticlePeer.TABLE_NAME + ";"));
        Record record = (Record)v.elementAt(0);
        return record.getValue(1).asInt();
    }

    public static Article[] searchByTitle(String query) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(TITLE, (Object)query, " LIKE ");
        criteria.addDescendingOrderByColumn(DATE_FOUND);
        return ArticlePeer.returnArticles(criteria);
    }

    public static Article[] searchByDescription(String query) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(DESCRIPTION, (Object)query, " LIKE ");
        criteria.addDescendingOrderByColumn(DATE_FOUND);
        return ArticlePeer.returnArticles(criteria);
    }

    public static Article[] searchByTitleAndDescription(String query) throws Exception {
        Criteria crit = new Criteria();
        Criteria.Criterion byTitle = crit.getNewCriterion(BaseArticlePeer.TITLE, (Object)query, " LIKE ");
        Criteria.Criterion byDescription = crit.getNewCriterion(BaseArticlePeer.DESCRIPTION, (Object)query, " LIKE ");
        crit.add(byTitle.or(byDescription));
        crit.addDescendingOrderByColumn(DATE_FOUND);
        return ArticlePeer.returnArticles(crit);
    }

    public static Article[] searchByChannelUnreadOnly(String channel) throws Exception {
        RuntimeUtil ru = new RuntimeUtil();
        BasePeer.executeStatement((String)"SET MAXROWS 15");
        Criteria criteria = new Criteria();
        criteria.add(CHANNEL, (Object)channel);
        criteria.add(MARKED_READ, 0);
        criteria.addDescendingOrderByColumn(DATE_FOUND);
        Article[] articles = ArticlePeer.returnArticles(criteria);
        BasePeer.executeStatement((String)"SET MAXROWS 0");
        ru.output();
        return articles;
    }

    private static Article[] returnArticles(Criteria crit) throws Exception {
        Vector v = BaseArticlePeer.doSelect(crit);
        Article[] content = new Article[v.size()];
        v.copyInto((Object[])content);
        return content;
    }

    public static void markAllSubscriptionsRead() throws Exception {
        Criteria selectCriteria = new Criteria();
        Criteria updateCriteria = new Criteria();
        selectCriteria.add(MARKED_READ, 0);
        updateCriteria.add(MARKED_READ, 1);
        ArticlePeer.doUpdate(selectCriteria, updateCriteria);
    }

    public static void markAllSubscriptionsUnread() throws Exception {
        Criteria selectCriteria = new Criteria();
        Criteria updateCriteria = new Criteria();
        selectCriteria.add(MARKED_READ, 1);
        updateCriteria.add(MARKED_READ, 0);
        ArticlePeer.doUpdate(selectCriteria, updateCriteria);
    }

    public static void doUpdate(Criteria selectCriteria, Criteria updateCriteria) throws Exception {
        selectCriteria.setDbName(BaseArticlePeer.getMapBuilder().getDatabaseMap().getName());
        updateCriteria.setDbName(BaseArticlePeer.getMapBuilder().getDatabaseMap().getName());
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)updateCriteria);
    }
}

