/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.init;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;

public class SystemPropertyInitializer {
    private ServletConfig config;

    public SystemPropertyInitializer(ServletConfig config) {
        this.config = config;
    }

    public void init() throws Exception {
        System.out.println("Virtual Machine information: ");
        System.out.println("------");
        this.dump("java.runtime.name");
        this.dump("java.runtime.version");
        this.dump("java.specification.vendor");
        this.dump("java.vm.info");
        this.dump("java.vm.name");
        System.out.println("------");
        System.out.println("Loading system properties...");
        System.out.println("------");
        Properties props = new Properties();
        props.load(this.config.getServletContext().getResourceAsStream("/WEB-INF/etc/system.properties"));
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (System.getProperty(key) != null) continue;
            System.getProperties().put(key, props.get(key));
            this.dump(key);
        }
        System.out.println("------");
        System.out.println("Loading system properties...done");
    }

    private void dump(String name) {
        System.out.println(name + " == " + System.getProperty(name));
    }
}

