/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.feeds.tasks;

import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.feeds.xml.OCSContentFeedsHandler;
import org.openprivacy.reptile.tasks.BaseTask;
import org.openprivacy.reptile.tasks.Task;
import org.openprivacy.reptile.util.ReptileResources;
import talon.util.Log;
import talon.util.net.URI;

public class FeedUpdateTask
extends BaseTask
implements Task {
    private String location;
    private String contentType;
    private Proxy proxy = ReptileResources.getInstance().getProxy();

    public FeedUpdateTask(String location, String contentType) {
        this.location = location;
        this.contentType = contentType;
        this.setIdentifier(location);
    }

    public void run() throws Exception {
        if (this.requireNotStale(this.location)) {
            return;
        }
        URI uri = new URI(this.location);
        ProxyEntry entry = this.proxy.getAndWait(uri);
        this.update(entry);
        this.setLastMessage("Successful");
    }

    public void update(ProxyEntry entry) {
        block2: {
            String proxiedLocation = entry.getIdentifier().toString();
            if (!proxiedLocation.equals(this.location) || !OCSContentFeedsHandler.isOCSNamespace(this.contentType)) break block2;
            try {
                new OCSContentFeedsHandler(this.location);
            }
            catch (Throwable t) {
                Log.error((Object)this, (Throwable)t);
                this.setLastMessage(t.getMessage());
            }
        }
    }
}

