/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions.om;

import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.openprivacy.reptile.ContentTransformerMap;
import org.openprivacy.reptile.om.Channel;
import org.openprivacy.reptile.om.ChannelPeer;
import org.openprivacy.reptile.om.Image;
import org.openprivacy.reptile.om.ImagePeer;
import talon.util.Log;

public class ChannelExtension {
    private ContentTransformerMap map = new ContentTransformerMap();

    public int count(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            return ChannelPeer.getCount();
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return -1;
        }
    }

    public boolean isSupportedContentType(String contentType) {
        return this.map.isSupportedContentType(contentType);
    }

    public String getTitle(String location) {
        try {
            return ChannelPeer.getChannelByLocation(location).getTitle();
        }
        catch (Exception e) {
            Log.error((String)location);
            Log.error((Throwable)e);
            return "UNKNOWN";
        }
    }

    public boolean isSubscription(String location) {
        try {
            Channel channel = ChannelPeer.getChannelByLocation(location);
            return channel != null && channel.isSubscription();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isChannel(String location) {
        try {
            Channel channel = ChannelPeer.getChannelByLocation(location);
            return channel != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getContentType(String location) {
        try {
            return ChannelPeer.getChannelByLocation(location).getContentType();
        }
        catch (Exception e) {
            Log.error((String)location);
            Log.error((Throwable)e);
            return "UNKNOWN";
        }
    }

    public String getImage(String channel) {
        String default_image = "/reptile/images/channel.png";
        try {
            Image image = ImagePeer.getImageByChannel(channel);
            if (image == null || image.getLocation() == null || image.getLocation().equals("")) {
                return default_image;
            }
            return image.getLocation();
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return default_image;
        }
    }
}

