/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions.om;

import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.openprivacy.reptile.extensions.TimeStamp;
import org.openprivacy.reptile.om.Article;
import org.openprivacy.reptile.om.ArticlePeer;
import talon.util.Log;

public class ArticleExtension {
    public int count(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            return ArticlePeer.getCount();
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return -1;
        }
    }

    public String getDateFound(String location) {
        String dateFound = null;
        TimeStamp timestamp = new TimeStamp();
        try {
            Article article = ArticlePeer.getArticleByLocation(location);
            if (article == null) {
                Log.error((String)("Couldn't get date found for location: " + location));
            } else {
                dateFound = timestamp.get(article.getDateFound());
            }
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
        }
        if (dateFound == null) {
            dateFound = timestamp.get(System.currentTimeMillis());
        }
        return dateFound;
    }

    public String getTitle(String location) {
        try {
            return ArticlePeer.getArticleByLocation(location).getTitle();
        }
        catch (Exception e) {
            Log.error((String)location);
            Log.error((Throwable)e);
            return "UNKNOWN";
        }
    }

    public String getDescription(String location) {
        try {
            return ArticlePeer.getArticleByLocation(location).getDescription();
        }
        catch (Exception e) {
            Log.error((String)location);
            Log.error((Throwable)e);
            return "UNKNOWN";
        }
    }
}

