/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import java.text.DateFormat;
import java.util.Date;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.openprivacy.reptile.extensions.ProxyFunctions;
import talon.Assert;
import talon.util.Log;

public class TimeStamp {
    public String get(XSLProcessorContext context, ElemExtensionCall elem) {
        return this.get();
    }

    public String get() {
        return this.get(System.currentTimeMillis());
    }

    public String get(String longDate) {
        return this.get(Long.parseLong(longDate));
    }

    public String get(long date) {
        return DateFormat.getDateTimeInstance(0, 0).format(new Date(date));
    }

    public String interval(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String s_difference = elem.getAttribute("difference", context.getContextNode(), context.getTransformer());
            Assert.assert((Object)s_difference, (String)"Difference attribute not specfied.");
            return ProxyFunctions.getDateFormated(Long.valueOf(s_difference));
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return t.getMessage();
        }
    }

    public String time_since(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String s_time = elem.getAttribute("time", context.getContextNode(), context.getTransformer());
            Assert.assert((Object)s_time, (String)"Difference attribute not specfied.");
            long difference = System.currentTimeMillis() - Long.valueOf(s_time);
            return ProxyFunctions.getDateFormated(difference);
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return t.getMessage();
        }
    }
}

