/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.openprivacy.reptile.util.ParameterPasser;
import talon.util.Log;
import talon.util.StringUtils;

public class LinkProducer {
    private StringBuffer link = new StringBuffer();
    private ParameterPasser params = new ParameterPasser();

    public LinkProducer() {
    }

    public LinkProducer(ParameterPasser params, HttpSession session, String sequenceName) {
        this.link = new StringBuffer();
        this.link.append(session.getAttribute("reptile.home.location"));
        this.params = new ParameterPasser();
        this.value("reptile.sequence.name", sequenceName);
    }

    public void newLink(XSLProcessorContext context, ElemExtensionCall elem) {
        this.link = new StringBuffer();
        this.params = new ParameterPasser();
        this.link.append(this.getParameter(context, "reptile.home.location"));
    }

    public void newLink(ParameterPasser params) {
        this.link = new StringBuffer();
        this.params = new ParameterPasser();
        this.link.append(params.getString("reptile.home.location"));
    }

    public void param(XSLProcessorContext context, ElemExtensionCall elem) {
        String name = elem.getAttribute("name");
        String value = this.getParameter(context, name);
        this.add(name, value);
    }

    public void param(String name, ServletRequest request) {
        String value = request.getParameter(name);
        this.add(name, value);
    }

    public void value(XSLProcessorContext context, ElemExtensionCall elem) {
        String name = elem.getAttribute("name");
        String value = null;
        try {
            value = elem.getAttribute("value", context.getContextNode(), context.getTransformer());
            this.add(name, value);
        }
        catch (TransformerException t) {
            Log.error((Throwable)t);
        }
    }

    public void value(String name, String value) {
        this.add(name, value);
    }

    private void add(String name, String value) {
        if (value != null && !value.equals("")) {
            this.params.put(name, this.encode(value));
        }
    }

    public String getLink() {
        int size = this.params.size();
        int i = 0;
        Enumeration keys = this.params.keys();
        while (keys.hasMoreElements()) {
            if (i == 0) {
                this.link.append("?");
            }
            String name = (String)keys.nextElement();
            String value = (String)this.params.get(name);
            this.link.append(name);
            this.link.append("=");
            this.link.append(value);
            if (i < size - 1) {
                this.link.append("&");
            }
            ++i;
        }
        return this.link.toString();
    }

    public String toString() {
        return this.getLink();
    }

    private String getParameter(XSLProcessorContext context, String name) {
        String value = (String)context.getTransformer().getParameter(name);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void include(ParameterPasser params) {
        Enumeration keys = params.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = params.getString(name);
            if (name.equals("reptile.action") || name.equals("reptile.action.next.sequence") || name.equals("reptile.action.next.layer") || name.equals("reptile.home.location") || name.equals("reptile.sequence.name") || name.equals("reptile.current.location")) continue;
            Log.debug((String)("LinkProducer: found param " + name));
            this.value(name, value);
        }
    }

    public void include(XSLProcessorContext context, ElemExtensionCall elem) {
        this.include(this.params);
    }

    private void reset() {
    }

    private String encode(String value) {
        if (value.indexOf("://") != -1) {
            value = URLEncoder.encode(value);
        } else {
            value = StringUtils.replaceAll((String)value, (String)" ", (String)"%20");
            value = StringUtils.replaceAll((String)value, (String)"/", (String)"%2F");
        }
        return value;
    }
}

