/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import java.net.URLEncoder;
import org.apache.regexp.RE;
import org.jdom.output.XMLOutputter;

public class EscapeExtension {
    private EscapeOutputter outputter = new EscapeOutputter();

    public String attributes(String content) {
        return this.outputter.escapeAttributeEntities(content);
    }

    public String html(String content) {
        try {
            RE aRegexp = new RE("&lt;a href=\"([^\"]+)\"&gt;([A-Za-z0-9]+)&lt;/a&gt;");
            while (aRegexp.match(content)) {
                String match = aRegexp.getParen(0);
                String link = aRegexp.getParen(1);
                String title = aRegexp.getParen(2);
                String replacement = "<a href=\"" + link + "\">" + title + "</a>";
                content = aRegexp.subst(match, replacement);
            }
            return content;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return content;
        }
    }

    public String encode(String data) {
        return URLEncoder.encode(data);
    }

    public static void main(String[] args) {
        System.out.println(new EscapeExtension().html("&lt;a href=\"http://www.apple.com/\"&gt;Apple&lt;/a&gt;"));
    }

    class EscapeOutputter
    extends XMLOutputter {
        EscapeOutputter() {
        }

        public String escapeAttributeEntities(String content) {
            return super.escapeAttributeEntities(content);
        }
    }
}

