/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import java.io.InputStream;
import javax.xml.transform.Transformer;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ContentTransformerHandler;
import org.openprivacy.reptile.xml.serializers.ErrorXMLSerializer;
import org.openprivacy.reptile.xslt.SequenceDispatchEntry;
import org.openprivacy.reptile.xslt.SequenceDispatcher;
import org.openprivacy.reptile.xslt.StylesheetEngineFactory;
import org.openprivacy.reptile.xslt.StylesheetStack;
import talon.Assert;
import talon.util.InputStreamUtils;
import talon.util.Log;

public class ContentTransformer {
    public static final String REPTILE_CONTENT_LOCATION_KEY = "reptile.content.location";
    public static final String REPTILE_CONTENT_TYPE_KEY = "reptile.content.type";
    private ParameterPasser params = null;

    public ContentTransformer(ParameterPasser params) {
        this.params = params;
    }

    public ContentTransformer() {
    }

    public void init(XSLProcessorContext context, ElemExtensionCall elem) {
        Log.debug((String)"INIT ContentTransformer");
        this.params = new ParameterPasser((Transformer)context.getTransformer());
    }

    public String transform(String location, String inputFormat, String outputFormat) {
        Assert.assert((Object)location, (String)"Location must be specified.");
        Assert.assert((Object)inputFormat, (String)"inputFormat must be specified.");
        Assert.assert((Object)outputFormat, (String)"outputFormat must be specified.");
        if (inputFormat.equals(outputFormat)) {
            Log.debug((String)("inputFormat and outputFormat are identical: " + inputFormat));
            try {
                Proxy proxy = ReptileResources.getInstance().getProxy();
                ProxyEntry entry = proxy.get(location);
                return InputStreamUtils.toString((InputStream)entry.getInputStream());
            }
            catch (Throwable t) {
                Log.error((Throwable)t);
                return new ErrorXMLSerializer(t).serializeAsString();
            }
        }
        Log.debug((String)("Transforming location: " + location + " with inputFormat: " + inputFormat));
        this.params.put(REPTILE_CONTENT_LOCATION_KEY, location);
        this.params.put(REPTILE_CONTENT_TYPE_KEY, inputFormat);
        if (inputFormat.equals(ReptileResources.STYLESHEET_SEQUENCE_NAMESPACE)) {
            try {
                return SequenceDispatcher.dispatch(location, this.params);
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                return new ErrorXMLSerializer(e).serializeAsString();
            }
        }
        try {
            ContentTransformerHandler handler = new ContentTransformerHandler(inputFormat, outputFormat);
            StylesheetStack ss = handler.getStylesheetStack();
            SequenceDispatchEntry sde = new SequenceDispatchEntry("urn:content-transformer");
            String skeleton = handler.getSkeleton();
            if (skeleton != null) {
                sde.setSkeleton(skeleton);
            } else {
                sde.setSkeleton(location);
            }
            sde.setLocation(location);
            sde.setStylesheetStack(ss);
            sde.setCacheable(true);
            String result = StylesheetEngineFactory.getStylesheetEngine().transform(sde, this.params);
            return result;
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            Log.debug((String)"Dumping serialized version of exception ");
            return new ErrorXMLSerializer(t).serializeAsString();
        }
    }

    public boolean isSupported(String contentType) {
        return contentType.equals("http://my.netscape.com/publish/formats/rss-0.91.dtd") || contentType.equals("http://my.netscape.com/rdf/simple/0.9/") || contentType.equals("http://my.netscape.com/publish/formats/rss-0.9.dtd") || contentType.equals("http://www.scripting.com/dtd/rss-0.92.dtd") || contentType.equals("http://purl.org/rss/1.0/");
    }
}

