/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.extensions.ContentTransformer;
import org.openprivacy.reptile.om.Channel;
import org.openprivacy.reptile.om.ChannelPeer;
import org.openprivacy.reptile.om.Image;
import org.openprivacy.reptile.om.ImagePeer;
import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.search.SearchProviderManager;
import org.openprivacy.reptile.search.SearchRecord;
import org.openprivacy.reptile.search.requests.RSSChannelSearchRequest;
import org.openprivacy.reptile.util.ReptileNamespaces;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.serializers.ErrorXMLSerializer;
import talon.util.Log;

public class ChannelRenderExtension {
    private XSLProcessorContext context = null;
    private ElemExtensionCall elem = null;
    static /* synthetic */ Class class$org$openprivacy$reptile$search$impl$ArticleSearchProvider;

    public String render(String location, String contentType) {
        if (location == null || contentType == null) {
            return new ErrorXMLSerializer("location or contentType not specified.").serializeAsString();
        }
        try {
            Channel channel = ChannelPeer.getChannelByLocation(location);
            if (channel != null && channel.isSubscription()) {
                return this.getAsSubscription(channel);
            }
            return this.getAsChannel(location, contentType);
        }
        catch (Throwable t) {
            Log.error((String)("Failed render for location: " + location));
            t.printStackTrace();
            return new ErrorXMLSerializer(t).serializeAsString();
        }
    }

    public String getAsSubscription(Channel channel) throws Exception {
        SearchProvider sp = SearchProviderManager.getInstance().newProvider(class$org$openprivacy$reptile$search$impl$ArticleSearchProvider == null ? (class$org$openprivacy$reptile$search$impl$ArticleSearchProvider = ChannelRenderExtension.class$("org.openprivacy.reptile.search.impl.ArticleSearchProvider")) : class$org$openprivacy$reptile$search$impl$ArticleSearchProvider);
        String location = channel.getLocation();
        RSSChannelSearchRequest request = new RSSChannelSearchRequest(location);
        sp.search(request);
        int count = sp.getResultCount();
        if (count == 0) {
            Log.warn((String)("Found zero articles for " + location));
        }
        SearchRecord record = new SearchRecord();
        Element rdf = new Element("RDF", ReptileNamespaces.JDOM_RDF);
        this.addChannel(rdf, channel);
        int max = request.getMaxCount();
        int i = 0;
        while (i < count && i < max) {
            record.setIndex(i);
            sp.record(record);
            Element item = new Element("item", ReptileNamespaces.JDOM_RSS);
            item.addContent(new Element("title", ReptileNamespaces.JDOM_RSS).setText(record.getTitle()));
            item.addContent(new Element("link", ReptileNamespaces.JDOM_RSS).setText(record.getLink()));
            item.addContent(new Element("description", ReptileNamespaces.JDOM_RSS).setText(record.getDescription()));
            rdf.addContent(item);
            ++i;
        }
        return this.output(rdf);
    }

    private void addChannel(Element rdf, Channel channel) throws Exception {
        Element rss_channel = new Element("channel", ReptileNamespaces.JDOM_RSS);
        rdf.addContent(rss_channel);
        rss_channel.addContent(new Element("title", ReptileNamespaces.JDOM_RSS).setText(channel.getTitle()));
        rss_channel.addContent(new Element("link", ReptileNamespaces.JDOM_RSS).setText(channel.getSite()));
        rss_channel.addContent(new Element("description", ReptileNamespaces.JDOM_RSS).setText(channel.getDescription()));
        Image image = ImagePeer.getImageByChannel(channel.getLocation());
        if (image != null) {
            Element rss_image = new Element("image", ReptileNamespaces.JDOM_RSS);
            rss_image.setAttribute("about", image.getLocation(), ReptileNamespaces.JDOM_RDF);
            rss_image.addContent(new Element("title", ReptileNamespaces.JDOM_RSS).setText(image.getTitle()));
            rss_image.addContent(new Element("link", ReptileNamespaces.JDOM_RSS).setText(channel.getSite()));
            rss_image.addContent(new Element("url", ReptileNamespaces.JDOM_RSS).setText(image.getLocation()));
            rss_channel.addContent(rss_image);
        }
    }

    public String getAsChannel(String location, String contentType) throws Exception {
        Proxy proxy = ReptileResources.getInstance().getProxy();
        ProxyEntry entry = proxy.getAndWait(location);
        location = entry.getFileLocation();
        ContentTransformer transformer = new ContentTransformer();
        transformer.init(this.context, this.elem);
        return transformer.transform(location, contentType, "http://purl.org/rss/1.0/");
    }

    private String output(Element element) {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setEncoding("ISO-8859-1");
        return outputter.outputString(element);
    }

    public void init(XSLProcessorContext context, ElemExtensionCall elem) {
        this.context = context;
        this.elem = elem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

