/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.actions;

import javax.servlet.http.HttpSession;
import org.openprivacy.reptile.actions.Action;
import org.openprivacy.reptile.actions.ActionDirective;
import org.openprivacy.reptile.cache.sequence.SequenceCache;
import org.openprivacy.reptile.om.ChannelPeer;
import org.openprivacy.reptile.util.ParameterPasser;
import talon.Assert;

public class UpdateReadMarks
implements Action {
    public static final String OPERATION_KEY = "reptile.feature.read-marks.operation";
    public static final String CONTENT_TYPE_KEY = "reptile.feature.read-marks.contentType";
    public static final String LOCATION_KEY = "reptile.feature.read-marks.location";
    public static final String OPERATION_READ = "read";
    public static final String OPERATION_UNREAD = "unread";

    public ActionDirective perform(ParameterPasser params, HttpSession session) throws Exception {
        String operation = params.getString(OPERATION_KEY);
        String contentType = params.getString(CONTENT_TYPE_KEY);
        String location = params.getString(LOCATION_KEY);
        Assert.assert((Object)operation, (String)"operation not found");
        Assert.assert((Object)contentType, (String)"contentType not found");
        Assert.assert((Object)location, (String)"location not found");
        if (operation.equals(OPERATION_READ)) {
            ChannelPeer.markChannelRead(location);
        } else if (operation.equals(OPERATION_UNREAD)) {
            ChannelPeer.markChannelUnread(location);
        } else {
            throw new Exception("invalid operation: " + operation);
        }
        SequenceCache.getInstance().flush(location);
        return null;
    }
}

