/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.actions;

import javax.servlet.http.HttpSession;
import org.openprivacy.reptile.actions.Action;
import org.openprivacy.reptile.actions.ActionDirective;
import org.openprivacy.reptile.extensions.LinkProducer;
import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.search.SearchProviderManager;
import org.openprivacy.reptile.search.SearchRequest;
import org.openprivacy.reptile.util.ParameterPasser;

public class Search
implements Action {
    public static final String PARAM_SEARCH_CRITERIA = "reptile.search.criteria";
    public static final String PARAM_SEARCH_PROVIDER = "reptile.search.provider";
    public static final String PARAM_SEARCH_REQUEST = "reptile.search.request";
    public static final String PARAM_SEARCH_ORDER = "reptile.search.order";
    public static final String PARAM_SEARCH_FIELDS = "reptile.search.fields";
    public static final String PARAM_SEARCH_MAXCOUNT = "reptile.search.maxcount";
    public static final String PARAM_SEARCH_PAGE = "reptile.search.page";
    public static final String PARAM_SEARCH_PROVIDER_HANDLE = "reptile.search.provider.handle";

    public ActionDirective perform(ParameterPasser params, HttpSession session) throws Exception {
        String criteria = params.getString(PARAM_SEARCH_CRITERIA);
        String provider = params.getString(PARAM_SEARCH_PROVIDER);
        if (criteria == null || provider == null) {
            throw new Exception("The criteria and provider must be specified.");
        }
        int maxcount = params.getInt(PARAM_SEARCH_MAXCOUNT, 100);
        String order = params.getString(PARAM_SEARCH_ORDER);
        String fields = params.getString(PARAM_SEARCH_FIELDS);
        SearchRequest request = new SearchRequest();
        request.addCriteria(criteria);
        request.setMaxCount(maxcount);
        if (fields != null) {
            String TITLE_DESCRIPTION = "title or description";
            if (TITLE_DESCRIPTION.equals(fields)) {
                request.addSearchField("title");
                request.addSearchField("description");
            } else {
                request.addSearchField(fields);
            }
        }
        SearchProvider sp = SearchProviderManager.getInstance().newProvider(provider, true);
        sp.search(request);
        ActionDirective ad = new ActionDirective();
        LinkProducer lp = new LinkProducer(params, session, "urn:search-serialize/page");
        lp.value(PARAM_SEARCH_PROVIDER_HANDLE, sp.getHandle());
        ad.setRedirect(lp.toString());
        return ad;
    }
}

