/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.actions;

import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openprivacy.reptile.actions.Action;
import org.openprivacy.reptile.actions.ActionDirective;
import org.openprivacy.reptile.extensions.LinkProducer;
import org.openprivacy.reptile.util.ParameterPasser;
import talon.util.Log;

public class ActionManager {
    public static boolean exec(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String action = request.getParameter("reptile.action");
            if (action != null) {
                Log.message((String)("Executing action: " + action));
                Action act = (Action)Class.forName("org.openprivacy.reptile.actions." + action).newInstance();
                ParameterPasser params = new ParameterPasser(request, response);
                HttpSession session = request.getSession();
                ActionDirective ad = act.perform(params, session);
                if (ad != null && ad.getRedirect() != null) {
                    response.sendRedirect(response.encodeURL(ad.getRedirect()));
                    return true;
                }
                return ActionManager.redirect(params, session, response);
            }
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            throw new ServletException(t.getMessage());
        }
        return false;
    }

    private static boolean redirect(ParameterPasser params, HttpSession session, HttpServletResponse response) throws Exception {
        String nextActionSequence = params.getString("reptile.action.next.sequence");
        String nextActionLayer = params.getString("reptile.action.next.layer");
        if (nextActionSequence != null) {
            LinkProducer link = new LinkProducer(params, session, nextActionSequence);
            link.include(params);
            if (nextActionLayer != null) {
                link.value("reptile.layer", URLEncoder.encode(nextActionLayer));
            }
            String encoded = response.encodeURL(link.getLink());
            Log.message((String)("ActionManager -> REDIRECTING TO: " + encoded));
            response.sendRedirect(encoded);
            return true;
        }
        return false;
    }
}

