/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Stack;
import org.apache.regexp.RE;
import talon.util.InputStreamUtils;

public class WellFormedContentParser {
    public static String parse(String input) throws Exception {
        StringBuffer output = new StringBuffer();
        String str_regexp = "<!--|</?([^/> ]+)([^>])*([ ]?/?>)?";
        RE regexp = new RE(str_regexp);
        int index = 0;
        String local_name = "";
        Stack<String> stack = new Stack<String>();
        while (regexp.match(input, index)) {
            if (WellFormedContentParser.isCommentBegin(regexp.getParen(0))) {
                RE comment_end = new RE("--[ ]?/?>");
                if (comment_end.match(input, index)) {
                    output.append(input.substring(index, comment_end.getParenEnd(0)));
                    index = comment_end.getParenEnd(0);
                    continue;
                }
                output.append(input.substring(index, input.length()));
                index = input.length();
                continue;
            }
            local_name = regexp.getParen(1).toLowerCase();
            String match = regexp.getParen(0);
            if (WellFormedContentParser.isNewElement(match)) {
                if (WellFormedContentParser.requiresSeltTermination(local_name)) {
                    output.append(input.substring(index, regexp.getParenEnd(0) - 1));
                    output.append("/>");
                } else {
                    stack.push(local_name);
                    output.append(input.substring(index, regexp.getParenEnd(0)));
                }
            } else if (WellFormedContentParser.isElementEnd(match)) {
                if (!stack.empty() && !local_name.equals(stack.peek())) {
                    output.append("</" + stack.peek() + ">");
                    output.append(input.substring(index, regexp.getParenStart(0)));
                } else {
                    output.append(input.substring(index, regexp.getParenEnd(0)));
                }
                if (!stack.empty()) {
                    stack.pop();
                }
            }
            index = regexp.getParenEnd(0);
        }
        output.append(input.substring(index, input.length()));
        while (!stack.empty()) {
            String next_element = (String)stack.pop();
            output.append("</" + next_element + ">");
        }
        return output.toString();
    }

    private static boolean isNewElement(String match) {
        return !WellFormedContentParser.isElementEnd(match) && !WellFormedContentParser.isSelfTerminating(match);
    }

    private static boolean isElementEnd(String match) {
        return match.startsWith("</");
    }

    private static boolean isSelfTerminating(String match) {
        return match.endsWith("/>");
    }

    private static boolean requiresSeltTermination(String name) {
        return name.equals("img") || name.equals("br") || name.equals("link") || name.equals("meta") || name.equals("hr");
    }

    private static boolean isCommentBegin(String match) {
        return match.equals("<!--");
    }

    public static void main(String[] args) {
        try {
            System.out.println(WellFormedContentParser.parse(InputStreamUtils.toString((InputStream)new FileInputStream(args[0]))));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

