/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openprivacy.reptile.ContentServlet;
import org.openprivacy.reptile.RSSWebsiteFilterSerializer;

public class WebsiteFilterServlet
extends HttpServlet {
    public static final String BASE_URI_PORTION = "/base";

    public void init(ServletConfig config) throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/rss+xml");
        String resource = ContentServlet.getResource(request);
        String base = null;
        int baseindex = resource.indexOf(BASE_URI_PORTION);
        if (baseindex != -1) {
            base = resource.substring(baseindex + BASE_URI_PORTION.length(), resource.length());
            resource = resource.substring(0, baseindex);
        }
        RSSWebsiteFilterSerializer rwfs = new RSSWebsiteFilterSerializer(resource);
        if (base != null) {
            rwfs.setBase(base);
        }
        PrintWriter out = response.getWriter();
        try {
            rwfs.parse();
            response.setStatus(202);
            String result = rwfs.getRSS();
            response.setStatus(200);
            response.setContentLength(result.length());
            out.print(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }

    public void destroy() {
    }
}

