/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.File;
import java.util.Vector;
import org.apache.catalina.startup.Bootstrap;

public class Startup {
    private static String java_home = null;
    private static String catalina_home = null;
    private static boolean debug = false;

    public static void main(String[] args) {
        try {
            System.out.println("Starting reptile...");
            Startup.init();
            Startup.startup();
            System.out.println("Initializing java environment...done");
        }
        catch (Exception e) {
            System.out.println("Reptile initialization FAILED! ");
            e.printStackTrace();
        }
    }

    public static void init() throws Exception {
        String new_java_home;
        java_home = System.getProperty("java.home");
        if (java_home.endsWith("/jre") && new File((new_java_home = java_home.substring(0, java_home.length() - "/jre".length())) + File.separatorChar + "jre").exists() && new File(new_java_home + File.separatorChar + "lib").exists()) {
            java_home = new_java_home;
        }
        catalina_home = System.getProperty("user.dir");
        System.out.println("Initializing java environment...");
        System.out.println("Using JAVA_HOME: " + java_home);
        System.out.println("Using CATALINA_HOME: " + catalina_home);
        System.setProperty("CATALINA_HOME", catalina_home);
        if (debug) {
            System.getProperties().list(System.out);
        }
        Startup.sanity();
        Startup.classpath();
        System.out.println("Initializing java environment...done");
    }

    public static void sanity() throws Exception {
        System.out.println("Performing sanity checks...");
        File confdir = new File(catalina_home + File.separatorChar + "conf");
        if (!confdir.exists() || !confdir.isDirectory()) {
            throw new Exception("CATALINA_HOME directory not contain 'conf' directory - " + confdir.getAbsolutePath());
        }
        System.out.println("Performing sanity checks...done");
    }

    public static void classpath() throws Exception {
        String bootstrap_jar = catalina_home + File.separator + "bin" + File.separator + "bootstrap.jar";
        String jxta_urn_handler_jar = catalina_home + File.separator + "lib" + File.separator + "jxta-urn-handler.jar";
        String tools_jar = null;
        tools_jar = java_home + File.separator + "lib" + File.separator + "tools.jar";
        Startup.addClasspathEntry(bootstrap_jar);
        Startup.addClasspathEntry(jxta_urn_handler_jar);
        Startup.addClasspathEntry(tools_jar);
        System.out.println("Using classpath: ");
        System.out.println(System.getProperty("java.class.path"));
    }

    public static void addClasspathEntry(String file) throws Exception {
        if (!new File(file).exists()) {
            System.out.println("Classpath entry does not exist: " + file);
        }
        System.out.println("Adding to classpath: " + file);
        String jcp = "java.class.path";
        System.setProperty(jcp, System.getProperty(jcp) + File.pathSeparatorChar + file);
    }

    public static void startup() throws Exception {
        System.out.println(ClassLoader.getSystemClassLoader().getClass().getName());
        Vector<String> v = new Vector<String>();
        v.addElement("start");
        Object[] args = new String[v.size()];
        v.copyInto(args);
        System.out.println("Starting Tomcat...");
        Bootstrap.main((String[])args);
    }
}

