/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.turbine.om.peer.BasePeer;
import org.openprivacy.reptile.actions.ActionManager;
import org.openprivacy.reptile.extensions.LinkProducer;
import org.openprivacy.reptile.init.ServletInitializer;
import org.openprivacy.reptile.tasks.TaskManager;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.SystemProperties;
import org.openprivacy.reptile.xslt.SequenceDispatcher;
import talon.util.Log;
import talon.util.RuntimeUtil;

public class ReptileServlet
extends HttpServlet {
    private Hashtable noAuthSequences = new Hashtable();
    private boolean initialized = false;

    public void init(ServletConfig config) throws ServletException {
        if (!this.initialized) {
            System.out.println("Reptile being initialized...");
            super.init(config);
            try {
                new ServletInitializer(config).init();
            }
            catch (Throwable t) {
                Log.error((Throwable)t);
            }
            this.noAuthSequences.put("urn:weblog-rss", "urn:weblog-rss");
            this.noAuthSequences.put("urn:ocs", "urn:ocs");
            System.out.println("Reptile being initialized...done");
            System.setProperty("reptile.system.initialized", "true");
            this.initialized = true;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        boolean auth_disabled = SystemProperties.getBoolean("reptile.system.auth-disabled");
        RuntimeUtil ru = new RuntimeUtil();
        HttpSession session = request.getSession();
        if (session.isNew()) {
            String session_location = response.encodeURL("/reptile/servlet/reptile");
            Log.message((String)("NEW SESSION " + session_location));
            session.setAttribute("reptile.home.location", (Object)session_location);
            if (!auth_disabled) {
                ParameterPasser params = new ParameterPasser(request, response);
                String redirect = new LinkProducer(params, session, "urn:login").getLink();
                response.sendRedirect(redirect);
                return;
            }
        }
        if (ActionManager.exec(request, response)) {
            return;
        }
        if (session.getAttribute("username") == null && !auth_disabled) {
            SequenceDispatcher.dispatch(request, response, "urn:login");
            ru.output();
            return;
        }
        String sequence = request.getParameter("reptile.sequence.name");
        if (sequence != null) {
            SequenceDispatcher.dispatch(request, response, sequence);
            ru.output();
            return;
        }
        PrintWriter out = response.getWriter();
        String defsequence = SystemProperties.getString("reptile.sequence.default");
        SequenceDispatcher.dispatch(request, response, defsequence);
        ru.output();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        System.out.println("ReptileServlet destroyed...");
        System.setProperty("reptile.system.restarted", "true");
        System.out.println("Shutting down database...");
        try {
            TaskManager.getInstance().destroy();
            System.out.println("Requesting database shutdown...");
            BasePeer.executeStatement((String)"SHUTDOWN COMPACT");
            System.out.println("Requesting database shutdown...done");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("Shutting down database...done");
        System.out.println("ReptileServlet destroyed...done");
    }
}

