/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.util.Vector;
import org.apache.regexp.RE;
import org.openprivacy.reptile.DocumentRelativizeDependency;
import org.openprivacy.reptile.ImageRelativizeDependency;
import org.openprivacy.reptile.LinkRelativizeDependency;
import org.openprivacy.reptile.RelativizeDependency;
import org.openprivacy.reptile.ScriptRelativizeDependency;

public class RelativizeContentParser {
    private String resource = null;
    private Vector dependencies = new Vector();

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public RelativizeDependency[] getDependencies() {
        Object[] depends = new RelativizeDependency[this.dependencies.size()];
        this.dependencies.copyInto(depends);
        return depends;
    }

    public String relativize(String content) throws Exception {
        String base = this.getBase();
        String site = this.getSite();
        StringBuffer buff = new StringBuffer();
        int index = 0;
        RE elementr = new RE("<(img|a|script|link)[^>]*(src|href)=[\"']([^\"']+)[\"'][^>]*/?>", 3);
        while (elementr.match(content, index) && index != -1) {
            RelativizeDependency dep;
            String local_name = elementr.getParen(1).toLowerCase();
            int bound = elementr.getParenEnd(0);
            String slink = elementr.getParen(3);
            buff.append(content.substring(index, elementr.getParenStart(3)));
            slink = this.expand(slink);
            buff.append(slink);
            if (local_name.equals("img")) {
                dep = new ImageRelativizeDependency();
                dep.resource = slink;
                this.addDependency(dep);
            } else if (local_name.equals("a")) {
                dep = new DocumentRelativizeDependency();
                ((DocumentRelativizeDependency)dep).resource = slink;
                this.addDependency(dep);
            } else if (local_name.equals("script")) {
                dep = new ScriptRelativizeDependency();
                ((ScriptRelativizeDependency)dep).resource = slink;
                this.addDependency(dep);
            } else if (local_name.equals("link")) {
                dep = new LinkRelativizeDependency();
                ((LinkRelativizeDependency)dep).resource = slink;
                this.addDependency(dep);
            }
            buff.append(content.substring(elementr.getParenEnd(3), elementr.getParenEnd(0)));
            index = elementr.getParenEnd(0);
        }
        buff.append(content.substring(index, content.length()));
        return buff.toString();
    }

    public String expand(String link) throws Exception {
        if (this.isInvalidScheme(link)) {
            return link;
        }
        if (link.startsWith("//")) {
            return "http:" + link;
        }
        if (link.startsWith("/")) {
            link = this.getSite() + link;
        } else if (link.startsWith("#")) {
            link = this.resource + link;
        } else if (link.startsWith("..")) {
            RE regexp = new RE("^\\.\\./?(.*)$", 1);
            RE baseRegexp = new RE("^(.*/)[^/]+/$", 1);
            String base = this.getBase() + "/";
            while (regexp.match(link)) {
                link = regexp.getParen(1);
                if (!baseRegexp.match(base)) continue;
                base = baseRegexp.getParen(1);
            }
            link = base + link;
        } else if (!link.startsWith("http://")) {
            String base = this.getBase();
            link = base + "/" + link;
        }
        return link;
    }

    public String getBase() {
        int begin = "http://".length() + 1;
        int end = this.resource.lastIndexOf("/");
        if (end == -1 || end <= begin) {
            end = this.resource.length();
        }
        return this.resource.substring(0, end);
    }

    public String getSite() {
        int end = this.resource.indexOf("/", 8);
        if (end == -1) {
            end = this.resource.length();
        }
        return this.resource.substring(0, end);
    }

    public void addDependency(RelativizeDependency depend) {
        if (!this.dependencies.contains(depend)) {
            this.dependencies.addElement(depend);
        }
    }

    public boolean isInvalidScheme(String resource) {
        return resource.startsWith("javascript:") || resource.startsWith("mailto:");
    }
}

