/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.regexp.RE;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;
import org.openprivacy.reptile.RSSContentSerializer;

public class RSSWebsiteFilterSerializer {
    private static final boolean DEBUG = true;
    private static final int MAX_ITEMS = 15;
    private RSSContentSerializer rcs = null;
    private String[] links = new String[0];
    private String html = null;
    private String base = "/20[0-1][0-9]";
    static /* synthetic */ Class class$org$openprivacy$reptile$RSSWebsiteFilterSerializer;

    public RSSWebsiteFilterSerializer(String resource) {
        this.rcs = new RSSContentSerializer();
        this.rcs.setResource(resource);
    }

    public void parse() throws Exception {
        this.rcs.parse();
        this.html = this.rcs.cleanseHTML(this.rcs.getResourceAsString());
        this.html = this.rcs.relativize(this.html);
        this.links = this.getAnchors(this.html);
        if (this.base.indexOf("$") == -1) {
            this.base = "^" + this.base;
        }
        RE regexp = new RE(this.base);
        Vector<String> results = new Vector<String>();
        int i = 0;
        while (i < this.links.length) {
            try {
                String link = this.links[i];
                String path = new URL(link).getPath();
                if (regexp.match(path) && !results.contains(link)) {
                    results.addElement(link);
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            ++i;
        }
        this.links = new String[results.size()];
        results.copyInto(this.links);
    }

    public String[] getAnchors(String html) throws Exception {
        int index = 0;
        RE regexp = new RE("<a href=\"([^\"]+)\"", 3);
        Vector<String> v = new Vector<String>();
        while (regexp.match(html, index)) {
            String link = regexp.getParen(1);
            v.addElement(link);
            index = regexp.getParenEnd(0);
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    public String getRSS() throws Exception {
        Namespace content_ns = Namespace.getNamespace((String)"content", (String)"http://purl.org/rss/1.0/modules/content/");
        Namespace rdf_ns = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Namespace rss_ns = Namespace.getNamespace((String)"rss", (String)"http://purl.org/rss/1.0/");
        Element rdf = new Element("RDF", rdf_ns);
        String resource = this.rcs.getResource();
        String title = this.rcs.getTitle();
        String description = this.rcs.getDescription();
        Element channel = new Element("channel", rss_ns);
        channel.setAttribute("about", resource, rdf_ns);
        rdf.addContent(channel);
        if (title == null) {
            channel.addContent(new Element("title", rss_ns).setText("content for: " + resource));
        } else {
            channel.addContent(new Element("title", rss_ns).setText(title));
        }
        channel.addContent(new Element("link", rss_ns).setText(resource));
        if (description == null) {
            channel.addContent(new Element("description", rss_ns).setText("Serialized content for the following URL: " + resource));
        } else {
            channel.addContent(new Element("description", rss_ns).setText(description));
        }
        Element itemseq = new Element("Seq", rdf_ns);
        channel.addContent(new Element("items", rss_ns).addContent(itemseq));
        int count = 0;
        int i = 0;
        while (i < this.links.length && count < 15) {
            block10: {
                block9: {
                    String link = this.links[i];
                    try {
                        RSSContentSerializer nrcs = new RSSContentSerializer();
                        nrcs.setResource(link);
                        nrcs.parse();
                        if (nrcs.getDescription() == null || nrcs.getDescription().equals("")) break block9;
                        String ititle = nrcs.getTitle();
                        if (this.isInvalidTitle(ititle)) break block10;
                        if (ititle.length() < 20 || this.isInsufficientTitle(nrcs)) {
                            ititle = nrcs.getTitle(nrcs.getDescription());
                        }
                        if (ititle == null || ititle.equals("")) {
                            ititle = nrcs.getTitle(nrcs.getDescription());
                        }
                        Element iteme = new Element("item", rss_ns);
                        iteme.setAttribute("about", link, rdf_ns);
                        iteme.addContent(new Element("title", rss_ns).setText(ititle)).addContent(new Element("link", rss_ns).setText(link)).addContent(new Element("description", rss_ns).setText(nrcs.getDescription())).addContent(new Element("encoded", content_ns).setText(nrcs.getContent()));
                        rdf.addContent(iteme);
                        itemseq.addContent(new Element("li", rdf_ns).setAttribute("resource", link, rdf_ns));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++count;
            }
            ++i;
        }
        String encoding = "UTF-8";
        XMLOutputter outputter = new XMLOutputter("    ", true, encoding);
        outputter.setEncoding(encoding);
        outputter.setOmitDeclaration(false);
        outputter.setOmitEncoding(false);
        return outputter.outputString(rdf);
    }

    private boolean isInvalidTitle(String title) {
        return title.equals("Thank you from washingtonpost.com");
    }

    private boolean isInsufficientTitle(RSSContentSerializer nrcs) {
        String title = nrcs.getTitle();
        String channelTitle = this.rcs.getTitle();
        if (title == null) {
            return true;
        }
        if (channelTitle.equals(title)) {
            return true;
        }
        if (title.indexOf(channelTitle) != -1) {
            return title.length() - channelTitle.length() < 5;
        }
        return false;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getBase() {
        return this.base;
    }

    public static void syntax() {
        System.out.println("SYNTAX: " + (class$org$openprivacy$reptile$RSSWebsiteFilterSerializer == null ? (class$org$openprivacy$reptile$RSSWebsiteFilterSerializer = RSSWebsiteFilterSerializer.class$("org.openprivacy.reptile.RSSWebsiteFilterSerializer")) : class$org$openprivacy$reptile$RSSWebsiteFilterSerializer).getName() + " URL [base]");
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            RSSWebsiteFilterSerializer.syntax();
        } else {
            String resource = args[0];
            RSSWebsiteFilterSerializer rcs = new RSSWebsiteFilterSerializer(resource);
            if (args.length == 2) {
                rcs.setBase(args[1]);
                System.err.println("Using base: " + rcs.getBase());
            }
            try {
                rcs.parse();
                System.out.println(rcs.getRSS());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void debug(String message) {
        System.err.println(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

