/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.util.Vector;
import org.apache.regexp.RE;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;
import org.openprivacy.reptile.RSSContentSerializer;

public class RSSANameChannelSerializer {
    private static final boolean DEBUG = true;
    private static final int MAX_ITEMS = 15;
    private RSSContentSerializer rcs = null;
    private String[] links = new String[0];
    private String html = null;
    static /* synthetic */ Class class$org$openprivacy$reptile$RSSANameChannelSerializer;

    public RSSANameChannelSerializer(String resource) {
        this.rcs = new RSSContentSerializer();
        this.rcs.setResource(resource);
    }

    public void parse() throws Exception {
        this.rcs.parse();
        this.html = this.rcs.cleanseHTML(this.rcs.getResourceAsString());
        this.links = this.getNamedAnchors(this.html);
    }

    public String[] getNamedAnchors(String html) throws Exception {
        int index = 0;
        RE regexp = new RE("<a name=\"([^\"]+)\"", 3);
        Vector<String> v = new Vector<String>();
        while (regexp.match(html, index) && v.size() < 15) {
            String link = this.rcs.getResource() + "#" + regexp.getParen(1);
            this.debug(link);
            v.addElement(link);
            index = regexp.getParenEnd(0);
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    public String getRSS() throws Exception {
        String site = this.rcs.getResource();
        String title = this.rcs.getTitle();
        String description = this.rcs.getDescription();
        Namespace content_ns = Namespace.getNamespace((String)"content", (String)"http://purl.org/rss/1.0/modules/content/");
        Namespace rdf_ns = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Namespace rss_ns = Namespace.getNamespace((String)"rss", (String)"http://purl.org/rss/1.0/");
        Element rdf = new Element("RDF", rdf_ns);
        Element channel = new Element("channel", rss_ns);
        channel.setAttribute("about", site, rdf_ns);
        rdf.addContent(channel);
        if (title == null) {
            channel.addContent(new Element("title", rss_ns).setText("content for: " + site));
        } else {
            channel.addContent(new Element("title", rss_ns).setText(title));
        }
        channel.addContent(new Element("link", rss_ns).setText(site));
        if (description == null) {
            channel.addContent(new Element("description", rss_ns).setText("Serialized content for the following URL: " + site));
        } else {
            channel.addContent(new Element("description", rss_ns).setText(description));
        }
        Element itemseq = new Element("Seq", rdf_ns);
        channel.addContent(new Element("items", rss_ns).addContent(itemseq));
        int i = 0;
        while (i < this.links.length) {
            String link = this.links[i];
            try {
                RSSContentSerializer nrcs = new RSSContentSerializer();
                nrcs.setResource(link);
                nrcs.setHTML(this.html);
                nrcs.setInitialized(true);
                nrcs.parse();
                if (nrcs.getDescription() != null && !nrcs.getDescription().equals("")) {
                    String ititle = nrcs.getTitle();
                    if (ititle == null || ititle.equals("")) {
                        ititle = nrcs.getTitle(nrcs.getDescription());
                    }
                    Element iteme = new Element("item", rss_ns);
                    iteme.setAttribute("about", link, rdf_ns);
                    iteme.addContent(new Element("title", rss_ns).setText(ititle)).addContent(new Element("link", rss_ns).setText(link)).addContent(new Element("description", rss_ns).setText(nrcs.getDescription())).addContent(new Element("encoded", content_ns).setText(nrcs.getContent()));
                    rdf.addContent(iteme);
                    itemseq.addContent(new Element("li", rdf_ns).setAttribute("resource", link, rdf_ns));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        String encoding = "UTF-8";
        XMLOutputter outputter = new XMLOutputter("    ", true, encoding);
        outputter.setEncoding(encoding);
        outputter.setOmitDeclaration(false);
        outputter.setOmitEncoding(false);
        return outputter.outputString(rdf);
    }

    public static void syntax() {
        System.out.println("SYNTAX: " + (class$org$openprivacy$reptile$RSSANameChannelSerializer == null ? (class$org$openprivacy$reptile$RSSANameChannelSerializer = RSSANameChannelSerializer.class$("org.openprivacy.reptile.RSSANameChannelSerializer")) : class$org$openprivacy$reptile$RSSANameChannelSerializer).getName() + " URL");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            RSSANameChannelSerializer.syntax();
        } else {
            String resource = args[0];
            RSSANameChannelSerializer rcs = new RSSANameChannelSerializer(resource);
            try {
                rcs.parse();
                System.out.println(rcs.getRSS());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void debug(String message) {
        System.err.println(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

