/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.regexp.RE;
import org.openprivacy.reptile.ContentServlet;
import org.openprivacy.reptile.xslt.SequenceDispatchEntry;
import org.openprivacy.reptile.xslt.StylesheetEngineFactory;
import org.openprivacy.reptile.xslt.StylesheetStack;

public class RSS2HTML
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        String resource = ContentServlet.getResource(request);
        if (resource == null) {
            response.sendRedirect("/reptile/rss2html.html");
        }
        System.out.println("RSS2HTML: " + resource);
        StylesheetStack ss = new StylesheetStack();
        ss.addStylesheet("resource://xsl/rss.xsl");
        SequenceDispatchEntry sde = new SequenceDispatchEntry("rss");
        sde.setStylesheetStack(ss);
        sde.setSkeleton(resource);
        sde.setCacheable(false);
        try {
            String output = StylesheetEngineFactory.getStylesheetEngine().transform(sde);
            response.getWriter().print(output);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resource = ContentServlet.getResource(request);
        if (resource == null) {
            response.sendRedirect("/reptile/rss2html.html");
        }
        try {
            RE regexp = new RE("http://");
            resource = regexp.subst(resource, "http/");
            regexp = new RE("#");
            resource = regexp.subst(resource, "%23");
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
        response.sendRedirect("/reptile/servlet/rss2html/" + resource);
    }

    public void destroy() {
    }
}

