/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openprivacy.reptile.RSSContentSerializer;

public class ContentServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/rss+xml");
        String resource = ContentServlet.getResource(request);
        RSSContentSerializer rcs = new RSSContentSerializer();
        rcs.setResource(resource);
        PrintWriter out = response.getWriter();
        try {
            rcs.parse();
            response.setStatus(202);
            String result = rcs.getRSS();
            response.setStatus(200);
            response.setContentLength(result.length());
            out.print(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }

    public static String getResource(HttpServletRequest request) throws ServletException {
        String resource = request.getParameter("resource");
        if (resource != null) {
            return resource;
        }
        String path = request.getPathInfo();
        if (path == null || path.equals("")) {
            throw new ServletException("No path info provided");
        }
        String scheme = (path = path.substring(1, path.length())).substring(0, path.indexOf("/"));
        if (!"http".equals(scheme)) {
            throw new ServletException("Only http URLs are supported.");
        }
        resource = "http://" + path.substring(path.indexOf("/") + 1, path.length());
        String qs = request.getQueryString();
        if (qs != null && !qs.equals("")) {
            resource = resource + "?" + qs;
        }
        return resource;
    }

    public void destroy() {
    }
}

